package sample_x5_nj_spring_ja;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import devpia.dextuploadnj.CompressUtil;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.spring.DEXTUploadNJFileDownloadView;

@Controller
public class FileServiceController implements ServletContextAware {
	
	private ServletContext servletContext;

	@Override
	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}
	
	@RequestMapping(value = {"/service/common-upload.do", "/service/upload-oraf.do"}, method = RequestMethod.POST)
	public void commonupload(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {
		
		// DEXTUploadX5RequestはSpringモデルバインディングによってフォームデータを持つVOクラスです。
		FileItem item = null;
		StringBuffer sb = new StringBuffer();
		
		for (MultipartFile file : x5.getDEXTUploadX5_FileData()) {
			
			item = (FileItem)file;
			
			if (item.isEmpty() == false) {
				// item が正しいファイルであれば、ファイルを一時的な場所からターゲットに保存（コピーまたは移動）します。
				// 引数として与えられたディレクトリパスがない場合、ターゲットは Environment#setDefaultRepository メソッドで設定されたパスになります。
				item.save();
				
				// 保存されたファイルの場所をレスポンスデータバッファに書き込む。
				sb.append(String.format("F:%1$s\n", item.getFilename()));
			}
		}		
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}

	@RequestMapping(value = "/service/metadata-upload.do", method = RequestMethod.POST)
	public void metaupload(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {		

		FileItem file = null;
		String form = null;
		StringBuffer sb = new StringBuffer();
		
		List<MultipartFile> items = x5.getDEXTUploadX5_FileData();
		List<String> metadata = x5.getDEXTUploadX5_MetaData();
		
		for (int i = 0, len = items.size(); i < len; i++) {
			
			file = (FileItem)items.get(i);
			form = metadata.get(i);
			
			if (file.isEmpty() == false) {
				file.save();
				
				sb.append(String.format("F:%1$s, M:%2$s\n", file.getFilename(), form));
			}
		}
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}
	
	@RequestMapping(value = "/service/upload-orof.do", method = RequestMethod.POST)
	public void uploadorof(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {
		
		FileItem file = (FileItem)x5.getDEXTUploadX5_FileData().get(0);
		
		if (file.isEmpty() == false) {
			file.save();
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(String.format("F:%1$s", file.getFilename()));
		} else {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(String.format("X:ファイルなし"));
		}
	}
	
	@RequestMapping(value = "/service/upload-file.do", method = RequestMethod.POST)
	public void uploadfile(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {
		
		FileItem item = null;
		StringBuffer sb = new StringBuffer();
		
		for (MultipartFile next : x5.getDEXTUploadX5_FileData()) {
			
			item = (FileItem)next;
			
			if (item.isEmpty() == false) {

				item.save();
				
				// FileEntity は、アップロードの結果を表示するのに役立つクラスです。
				FileEntity file = new FileEntity();
				file.setFieldName(item.getFieldName());
				file.setFilename(item.getFilename());
				file.setMime(item.getContentType());
				file.setSize(item.getFileSize());
				file.setFile(new File(item.getLastSavedFilePath()));
				
				String key = FileRepository.addFileEntity(file);
				
				sb.append(String.format("%1$s;", key));
			}
		}		
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}
	
	@RequestMapping(value = "/service/multiple-upload.do", method = RequestMethod.POST)
	public void multipleupload(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {
		
		FileItem file = null;
		String ctr = null;
		String fid = null;
		StringBuffer sb = new StringBuffer();
		
		List<MultipartFile> items = x5.getDEXTUploadX5_FileData();
		List<String> controls = x5.getDEXTUploadX5_ControlId();
		List<String> ids = x5.getDEXTUploadX5_UniqueId();
		
		for (int i = 0, len = items.size(); i < len; i++) {
			
			file = (FileItem)items.get(i);
			ctr = controls.get(i);
			fid = ids.get(i);
			
			if (file.isEmpty() == false) {
				file.save();
				
				sb.append(String.format("%1$s|%2$s|%3$s\n", ctr, fid, file.getFilename()));
			}
		}
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}

	@RequestMapping(value = "/service/folder-upload.do")
	public void folderupload(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {		

		FileItem file = null;
		String sub = null;
		File dir = null;
		StringBuffer sb = new StringBuffer();
		
		// ファイルコレクションオブジェクトを取得する。
		List<MultipartFile> items = x5.getDEXTUploadX5_FileData();
		// フォルダ パスのコレクション オブジェクトを取得する。 items.size() == folders.size()
		List<String> folders = x5.getDEXTUploadX5_Folder();
		
		for (int i = 0, len = items.size(); i < len; i++) {			
			file = (FileItem)items.get(i);
			if (file.isEmpty()) continue;
			
			sub = folders.get(i);			
			// ディレクトリ（フォルダ）情報を含む保存パスを取得する。
			dir = new File(file.getEnviroment().getDefaultRepository(), sub);
			// フォルダー構造を作成する。
			if (dir.exists() == false) dir.mkdirs();			
			// ファイルを保存先フォルダに保存します。
			file.save(dir.getCanonicalPath());
			sb.append(String.format("F:%1$s\n", file.getLastSavedFilePath()));
		}
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}
	
	@RequestMapping(value = "/service/exif-upload.do")
	public void exifupload(DEXTUploadX5Request x5, HttpServletResponse response) throws IOException {		

		FileItem file = null;
		String form = null;
		String[] tokens = null;
		StringBuffer sb = new StringBuffer();
		StringBuffer exif = new StringBuffer();
		
		List<MultipartFile> items = x5.getDEXTUploadX5_FileData();
		List<String> exifs = x5.getDEXTUploadX5_EXIFData();
		
		for (int i = 0, len = items.size(); i < len; i++) {
			
			file = (FileItem)items.get(i);
			form = exifs.get(i);
			
			if (file.isEmpty() == false) {
				file.save();
				
				tokens = form.split("\\[SPLT\\]");
				
				exif.delete(0, exif.length());
				for (int k = 0, klen = tokens.length; (k + 1) < klen; k += 2) {
					exif.append(String.format("%1$s:%2$s\n", tokens[k], tokens[k + 1]));
				}
				
				sb.append(String.format("F:%1$s\n%2$s\n", file.getLastSavedFilename(), exif.toString()));
			}
		}
				
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		response.getWriter().write(sb.toString());
	}
	
	@RequestMapping(value = "/service/common-download.do")
	public ModelAndView commondownload(@RequestParam(value = "key") String key, HttpServletRequest request, HttpServletResponse response) throws IOException {
		
		File target = null;
		
		String fileRoot = servletContext.getRealPath("/files/attach");
		
		if (key.equals("FID0001")) target = new File(fileRoot, "bridge_509147.jpg");
		else if (key.equals("FID0002")) target = new File(fileRoot, "beach_239826.jpg");
		else if (key.equals("FID0003")) target = new File(fileRoot, "cosmos (empty) 195779.jpg");
		
		// エンコーディングをUTF-8にする。
		response.setCharacterEncoding("UTF-8");
		
		if (target == null  || target.exists() == false || target.isFile() == false) {
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "キーのファイルが見つかりません。");
			return null;
		} else {
			DEXTUploadNJFileDownloadView dextnj = new DEXTUploadNJFileDownloadView(target);
			if (request.getHeader("User-Agent").indexOf("DEXTUploadX5") >= 0) {
				dextnj.setAllowingWeakRange(true);
			} else {
				dextnj.setUseClientCache(false);
			}
			return new ModelAndView(dextnj);
		}
	}
	
	@RequestMapping(value = "/service/common-open.do")
	public ModelAndView commonopen(@RequestParam(value = "key") String key, HttpServletResponse response) throws IOException {
		
		File target = null;
		
		String fileRoot = servletContext.getRealPath("/files/attach");
		
		if (key.equals("FID0001")) target = new File(fileRoot, "bridge_509147.jpg");
		else if (key.equals("FID0002")) target = new File(fileRoot, "beach_239826.jpg");
		else if (key.equals("FID0003")) target = new File(fileRoot, "cosmos (empty) 195779.jpg");
		
		// エンコーディングをUTF-8にする。
		response.setCharacterEncoding("UTF-8");
		
		if (target == null  || target.exists() == false || target.isFile() == false) {
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "キーのファイルが見つかりません。");
			return null;
		} else {
			DEXTUploadNJFileDownloadView dextnj = new DEXTUploadNJFileDownloadView(target);
			dextnj.setMime("image/jpg");
			dextnj.setInline(true);
			return new ModelAndView(dextnj);
		}
	}
	
	@RequestMapping(value = "/service/compress.do", method = RequestMethod.POST)
	public void makeCompressedFile(@RequestParam(value = "DEXTUploadX5_VIndexes") String vindices, HttpServletRequest request, HttpServletResponse response) throws IOException {
		
		String fileRoot = servletContext.getRealPath("/files");
		
		List<File> files = new ArrayList<File>();
		String[] tokens = vindices.split(",");
		for (int i = 0; i < tokens.length; i++) {
			if (tokens[i].equals("IDX0003"))
				files.add(new File(fileRoot, "attach/bridge_509147.jpg"));
			if (tokens[i].equals("IDX0004"))
				files.add(new File(fileRoot, "attach/beach_239826.jpg"));
			if (tokens[i].equals("IDX0005"))
				files.add(new File(fileRoot, "attach/cosmos (empty) 195779.jpg"));
		}
		
		// 一時的な場所に圧縮ファイルを作成する。
		CompressUtil cu = new CompressUtil();
		File zipped = cu.zip(files, new File(fileRoot, "/temp/"), "UTF-8", false, false);
		
		
		FileEntity target = new FileEntity();
		target.setMime("application/x-zip-compressed");
		target.setFilename(zipped.getName());
		target.setFile(zipped);
		target.setSize(zipped.length());
		
		String compresskey = FileRepository.addFileEntity(target);
		
		response.setContentType("text/plain");		
		response.getWriter().write(request.getRequestURL().append("?compresskey=".concat(compresskey)).toString());
	}
	
	@RequestMapping(value = "/service/compress.do", method = RequestMethod.GET)
	public ModelAndView downloadCompressedFile(@RequestParam(value = "compresskey") String key, HttpServletResponse response) throws IOException {
		
		FileEntity target = FileRepository.getFileEntity(key);
				
		if (target != null) {
			DEXTUploadNJFileDownloadView dextnj = new DEXTUploadNJFileDownloadView();
			dextnj.setFile(target.getFile());
			dextnj.setCharsetName("UTF-8");
			dextnj.setAllowingWeakRange(false);
			dextnj.setUseClientCache(false);
			dextnj.setRemoveAfterDownloading(true);
			return new ModelAndView(dextnj);
		} else {
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "キーのファイルが見つかりません。");
			return null;
		}
	}
	
	@RequestMapping(value = "/service/hdevent.do")
	public void hdevent(@RequestParam(value = "action") String action, @RequestParam(value = "key") String key) throws IOException {
		
		// 標準出力に印刷する。
		System.out.println(String.format("Action: %s, Key: %s", action, key));
	}
}
