package sample_x5_nj_spring_ko;

import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ExtensionSampleController {	
	
	@RequestMapping(value = "/service/form-process.ext", method = RequestMethod.POST)
	public String formprocess(
			/* DataEntity는 폼에서 전달되는 값을 가지고 있는 VO 클래스로써 일종의 예시이다. */
			DataEntity data,
			@RequestParam(value = "newFileKeys", required = false) String newFileKeys,
			@RequestParam(value = "deleteFileKeys", required = false) String deleteFileKeys,
			HttpServletResponse response) {
		
		List<FileEntity> files = data.getFiles();
		
		// DB에 저장된 파일 정보를 DataEntity 인스턴스에 연결하는 작업으로 이해하면 된다.
		String[] tokens = newFileKeys.split(";");
		for (String key : tokens) {
			if (key.isEmpty() == false) {
				files.add(FileRepository.getFileEntity(key));
			}
		}
		
		if (deleteFileKeys != null && deleteFileKeys.length() > 0) {
			data.setDeleteDescription(deleteFileKeys + " 파일이 삭제되었습니다.");
		} else {
			data.setDeleteDescription("삭제된 파일이 없습니다.");
		}
		
		// DB에 새로운 데이터를 등록하며, 이때, 데이터와 파일은 관계를 갖도록 연결할 수 있다.
		String key = DataRepository.addDataEntity(data);
		
		if (deleteFileKeys != null) {
			// 만일 삭제된 파일 정보가 있다면, 물리적 파일을 이 시점에 삭제해야 한다.
		}
		
		return "redirect:/result/view-form.ext?key=".concat(key);
	}
	
	@RequestMapping(value = "/result/view-form.ext", method = RequestMethod.GET)
	public ModelAndView viewform(@RequestParam(value = "key") String key) {
		DataEntity data = DataRepository.getDataEntity(key);
		return new ModelAndView("/view-form-ext", "data", data);
	}
}
