package sample_x5_nj_spring_en;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.sas.SasProtocol;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AzureSasTokenGenerator {
	
	private final static String ACCOUNT_NAME = "";
	private final static String CONTAINER_NAME = "";
	private final static String ACCESSKEY = "";
	
	public String generateBlobListSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
        // SAS validity period (server time difference adjustment: starts 5 minutes early, valid for 1 hour)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // Permissions: Read + List (required to read the list of uncommitted blocks)
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true)
                .setListPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Generate SAS token based on blob
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}
	
	public String generateContainerSasToken() {
        	
    	StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
    	
        // SAS validity period (server time difference adjustment: starts 5 minutes early, valid for 1 hour)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // Permissions: Create + Write (create new blob)
        BlobSasPermission permissions = new BlobSasPermission()
        		.setCreatePermission(true)
        		.setWritePermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);	        
        
        // Generate SAS token based on container
        String sasToken = containerClient.generateSas(sasValues);
        
        return sasToken;
        
	}
	
	public String generateBlobSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
        // SAS validity period (server time difference adjustment: starts 5 minutes early, valid for 1 hour)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // Permissions: Read (required to read the Blob contents)
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Generate SAS token based on blob
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}

}
