class AbortError extends Error{constructor(t){super(t);this.name="AbortError"}}class DX5FileItem{constructor(){this.controlId="";this.id="";this.vindex="";this.type="";this.name="";this.ext="";this.openUrl="";this.downUrl="";this.url="";this.lock=false;this.mime="";this.size=-1;this.mdate=null;this.thumbnail="";this.status="WAIT";this.checked=false;this.ofile=null;this.meta={};this.onUpdated=null;this.mdate=0;this.path="";this.middlePath="";this.imageWidth=0;this.imageHeight=0;this.exif="";this.eventUriStart="";this.eventUriStop="";this.eventUriEnd="";this.chunkSize=-1;this.hdTitle=""}update(){if(this.onUpdated&&typeof this.onUpdated==="function"){this.onUpdated(this)}}toVirtual(t,e){if(this.type!=="FILE")return;this.type="VIRTUAL";this.status="WAIT";if(typeof t!="undefined"){this.openUrl=t}if(typeof e!="undefined"){this.downUrl=this.url=e}this.update()}toString(){return"[object DX5FileItem]"}toContentString(){return this.id+" "+this.type+" "+this.status+" "+this.checked}}class DX5FileList extends Array{constructor(){super();this.totalSizeA=0;this.totalSizeL=0;this.virtualLength=0}update(){this.totalSizeA=0;this.totalSizeL=0;this.virtualLength=0;for(var t=0;t<this.length;t++){if(false==(this[t].toString()=="[object DX5FileItem]"))continue;if(this[t].size>0)this.totalSizeA+=this[t].size;if("FILE"==this[t].type&&this[t].ofile){this.totalSizeL+=this[t].ofile.size}else if("VIRTUAL"==this[t].type){this.virtualLength++}}}onchanged(){this.update()}push(t){if(t.toString()=="[object DX5FileItem]"){Array.prototype.push.call(this,t);this.onchanged({state:"add",target:t})}else{console.info("f is not DX5FileItem => "+t.toString())}}pop(){var t=null;var e=true;while(e){t=Array.prototype.pop.call(this);if(!t)return null;if(t.toString()=="[object DX5FileItem]"){this.onchanged({state:"delete",target:t});e=false}}return t}shift(){var t=null;var e=true;while(e){t=Array.prototype.shift.call(this);if(!t)return null;if(t.toString()=="[object DX5FileItem]"){this.onchanged({state:"shift",target:t});e=false}}return t}getTotalSize(t){return t===true?this.totalSizeL:this.totalSizeA}getLength(t){return t===true?this.length-this.virtualLength:this.length}getItem(t){var e=null;for(var s=0;s<this.length;s++){if(t==this[s].id){e=this[s];break}}return e}removeById(t){var e=null;for(var s=0;s<this.length;s++){e=this[s];if(t==e.id){this.splice(s,1);this.onchanged({state:"delete",target:e});break}}}removeByIndex(t){var e=null;if(t<this.length){e=this[t];this.splice(t,1);this.onchanged({state:"delete",target:e})}}removeByObject(t){var e=null;for(var s=0;s<this.length;s++){e=this[s];if(t==e){this.splice(s,1);this.onchanged({state:"delete",target:e});break}}}clear(t){for(var e=0;e<this.length;){if(t==this[e].type){this.splice(e,1)}else{e++}}this.onchanged({state:"clear",target:null})}}class DX5FileListManager{constructor(){this.ufiles=new DX5FileList;this.xfiles=new DX5FileList;this.cumulative=0}createId(t){return"DX5-"+(new Date).getTime()+"-"+t.toString(16)}createFI(t,e,s,r,i,n,o,a){const h=new DX5FileItem;h.controlId=t;h.ofile=s;if(s.lastModified){h.mdate=new Date(s.lastModified)}else{h.mdate=s.lastModifiedDate||new Date}h.id=e;h.vindex=r;h.type=i;h.name=n;h.size=o;h.status="WAIT";extend(h.meta,a);return h}adjustInteger(t,e,s){const r=parseInt(t,10);if(e)return r;else if(r<0)return s;else return r}addFile(t,e){let s=null,r=null;if(isFile(e)){s=this.createFI(t,this.createId(++this.cumulative),e,"","FILE",e.name,e.size);s.ext=getFileExtension(e.name);s.mime=e.type;var i=e.webkitRelativePath||e.relativePath||e.dx5RelativePath;if(i){s.middlePath=getParentPath(i)}}else if(e){r=new Blob([],{type:"application/octet-stream"});s=this.createFI(t,this.createId(++this.cumulative),r,e.vindex||"","VIRTUAL",e.name,typeof e.size==="undefined"?-1:this.adjustInteger(e.size,false,-1),e.meta);s.ext=getFileExtension(e.name);s.mime="application/octet-stream";s.openUrl=e.openUrl||"";s.downUrl=e.downUrl||e.url||"";s.url=s.downUrl;s.thumbnail=e.thumb||e.thumbUrl||"";s.lock=e.lock===true?true:false;s.checked=e.checked===true?true:false;s.eventUriStart=e.eventUriStart||"";s.eventUriStop=e.eventUriStop||"";s.eventUriEnd=e.eventUriEnd||"";s.chunkSize=typeof e.chunkSize==="undefined"?-1:this.adjustInteger(e.chunkSize,false,-1);s.hdTitle=e.hdTitle||"";s.middlePath=e.middlePath||e.folder||""}else return null;this.ufiles.push(s);return s}removeAllUFiles(){this.ufiles.splice(0,this.ufiles.length)}removeAllXFiles(){this.xfiles.splice(0,this.xfiles.length)}}class DX5UploadProgressStatus{constructor(){this.totalSize=0;this.totalCount=0;this.totalSendSize=0;this.completeCount=0;this.currentName="";this.currentSize=0;this.currentSendSize=0;this.$totalPrevSendSize=0;this.$uploadStartTime=null;this.$currentPrevSendSize=0;this.$currentStartTime=null;this.$currentChunkedSize=0;this.$currentHashTotal=0;this.$currentHashStep=0}clear(){this.totalSize=this.totalCount=this.totalSendSize=this.completeCount=0;this.$uploadStartTime=null;this.$totalPrevSendSize=0;this.clearItem()}clearItem(){this.currentName="";this.currentSize=this.currentSendSize=0;this.$currentChunkedSize=0;this.$currentStartTime=null;this.$currentPrevSendSize=0;this.$currentHashTotal=this.$currentHashStep=0}getTotalRate(){return this.totalSize==0?1:this.totalSendSize/this.totalSize}getTotalSendTime(){return this.$uploadStartTime?Date.now()-this.$uploadStartTime:0}getTotalSpeed(){var t=this.getTotalSendTime();return t==0?this.totalSendSize:this.totalSendSize*1e3/t}getCurrentRate(){return this.currentSize==0?1:this.currentSendSize/this.currentSize}getCurrentSendTime(){return this.$currentStartTime?Date.now()-this.$currentStartTime:0}getCurrentSpeed(){var t=this.getCurrentSendTime();return t==0?this.currentSendSize:this.currentSendSize*1e3/t}getRemainedTotalTime(){var t=this.totalSize-this.totalSendSize;var e=this.getCurrentSpeed();if(t>0){return e==0?Infinity:t*1e3/e}else{return 0}}getRemainedCurrentTime(){var t=this.currentSize-this.currentSendSize;var e=this.getCurrentSpeed();if(t>0){return e==0?Infinity:t*1e3/e}else{return 0}}getCurrentHashingRate(){return this.$currentHashTotal<=0?0:this.$currentHashStep/this.$currentHashTotal}change(t,e){this.$totalPrevSendSize=this.$totalPrevSendSize-this.$currentPrevSendSize+t;this.currentSendSize=this.$currentPrevSendSize=t;this.$currentChunkedSize=e}updateFileProgress(t,e){var s=t-this.$currentChunkedSize;var r=Math.max(e-s,0);this.currentSendSize=this.$currentPrevSendSize+r;this.totalSendSize=this.$totalPrevSendSize+r}updateHashProgress(t,e){this.$currentHashTotal=t;this.$currentHashStep=e}wrapup(t){this.$currentPrevSendSize=this.currentSendSize;this.$totalPrevSendSize=this.totalSendSize;if(t){this.fin=true;this.completeCount=this.completeCount+1}}}class DX5UploadStatus{constructor(){this.progress=new DX5UploadProgressStatus;this.xhr=null;this.type="ORAF";this.currentItem=null;this.currentChunkedAction="P";this.currentLocalKey="";this.currentResponseValue="";this.currentServerSize=0;this.currentRepetitive=0;this.abortFlag=false;this.cancelFlag=false;this.fin=false}clearItem(){this.fin=false;this.xhr=this.currentItem=null;this.currentChunkedAction="P";this.currentLocalKey=this.currentResponseValue="";this.currentServerSize=this.currentRepetitive=0;this.progress.clearItem()}clear(){this.clearItem();this.type="ORAF";this.abortFlag=this.cancelFlag=false;this.progress.clear()}init(t,e,s){this.clear();this.type=t;this.progress.$uploadStartTime=Date.now();this.progress.totalSize=e;this.progress.totalCount=s}setItem(t,e,s){this.clearItem();this.currentItem=t;this.progress.currentName=t?t.name:e;this.progress.currentSize=t?t.size:s}start(){if(this.currentChunkedAction==="P"){this.progress.$currentStartTime=Date.now()}}isRepeated(t){if(this.currentServerSize===t){this.currentRepetitive++}else{this.currentServerSize=t;this.currentRepetitive=0}return this.currentRepetitive>5}isNotCurrentFinished(){return this.currentItem!=null&&this.fin===false}isPreparation(){return this.currentChunkedAction==="P"}isAttaching(){return this.currentChunkedAction==="A"}isDone(){return this.currentChunkedAction==="D"}switchAction(t){if(typeof t==="undefined"){switch(this.currentChunkedAction){case"P":this.currentChunkedAction="A";break;case"D":this.currentChunkedAction="P";break;case"A":break;default:this.currentChunkedAction="P";break}}else{this.currentChunkedAction=t}}}class DX5DownloadStatus{constructor(){this.totalSize=0;this.totalCount=0;this.totalSendSize=0;this.totalPrevSendSize=0;this.completeCount=0;this.downloadStartTime=null;this.downloadCountTime=0;this.xhr=null;this.currentItem=null;this.currentName="";this.currentSize=0;this.currentSendSize=0;this.currentPrevSendSize=0;this.currentStartTime=null;this.currentCountTime=0;this.abortFlag=false;this.cancelFlag=false;this.url=null;this.availableRange=-1;this.index=0;this.pieces=0;this.chunk=0;this.flags=[];this.validUrl=false;this.fin=false;this.acc=null}clearItem(){this.xhr=null;this.currentStartTime=null;this.currentItem=null;this.url=null;this.currentName="";this.currentSize=this.currentSendSize=this.currentPrevSendSize=this.currentCountTime=0;this.availableRange=-1;this.index=this.pieces=this.chunk=0;this.flags=[];this.fin=this.validUrl=false;this.acc=null}clear(){this.downloadStartTime=null;this.totalSize=this.totalCount=this.totalSendSize=this.totalPrevSendSize=this.completeCount=this.downloadCountTime=0;this.abortFlag=this.cancelFlag=false;this.clearItem()}getTotalRate(){return this.totalSize==0?0:this.totalSendSize/this.totalSize}getTotalSpeed(){var t=this.downloadCountTime+this.currentCountTime;var e=~~(t/1e3);return e==0?this.totalSendSize:this.totalSendSize/e}getTotalSendTime(){return this.downloadStartTime?Date.now()-this.downloadStartTime:0}getCurrentRate(){return this.currentSize===0?0:this.currentSendSize/this.currentSize}getCurrentSendTime(){return this.currentStartTime?Date.now()-this.currentStartTime:0}getCurrentSpeed(){var t=this.currentCountTime;var e=~~(t/1e3);return e==0?this.currentSendSize:this.currentSendSize/e}getRemainedTotalTime(){var t=this.totalSize-this.totalSendSize;var e=this.getTotalSpeed();if(t>0){return e==0?Infinity:t*1e3/e}else{return 0}}getRemainedCurrentTime(){var t=this.currentSize-this.currentSendSize;var e=this.getCurrentSpeed();if(t>0){return e==0?Infinity:t*1e3/e}else{return 0}}reset(t,e){this.clear();this.downloadStartTime=Date.now();this.downloadCountTime=0;this.totalSize=t;this.totalCount=e;this.totalPrevSendSize=0;this.totalSendSize=0;this.completeCount=0}readyItem(t,e){this.clearItem();this.currentItem=t;this.currentName=t.name;this.currentSize=t.size;this.url=t.downUrl||t.url;this.chunk=e;this.currentStartTime=Date.now();this.currentCountTime=0}changeItemSize(t){this.totalSize=this.totalSize-(this.currentSize>0?this.currentSize:0)+t;this.currentSize=t}calculateNextRange(){var t=[];if(this.availableRange===0){this.index=1;this.pieces=1;t.push(0);t.push(0)}else if(this.index===0&&this.pieces===0){this.index=1;this.pieces=~~(this.currentSize/this.chunk)+(this.currentSize%this.chunk>0?1:0);t.push(0);t.push(Math.min(this.chunk-1,this.currentSize-1))}else if(!this.flags[this.index-1]){t.push((this.index-1)*this.chunk);t.push(this.index*this.chunk>this.currentSize?this.currentSize-1:this.index*this.chunk-1)}else{this.index++;t.push((this.index-1)*this.chunk);t.push(this.index*this.chunk>this.currentSize?this.currentSize-1:this.index*this.chunk-1)}return t}updateProgress(t){this.currentSendSize=this.currentPrevSendSize+t;this.totalSendSize=this.totalPrevSendSize+this.currentSendSize;this.currentCountTime=Date.now()-this.currentStartTime}accumulateData(t){this.acc=this.acc?new Blob([this.acc,t],{type:t.type}):t;this.flags[this.index-1]=true;this.currentPrevSendSize=this.acc.size}wrapupCurrent(){this.fin=true;this.currentSendSize=this.currentSize;this.totalPrevSendSize=this.totalPrevSendSize+this.currentSize;this.totalSendSize=this.totalPrevSendSize;this.downloadCountTime+=this.currentCountTime;this.completeCount++}isNotCurrentFinished(){return this.currentItem!=null&&this.fin===false}}class CommonTransfer{constructor(){this.JOB_STATE_READY=0;this.JOB_STATE_PROCESSING=1;this.JOB_STATE_DONE=2;this.JOB_STATE_CANCEL=3;this.JOB_STATE_ABORT=4;this.JOB_STATE_ERROR=5;this.JOB_STATE_PENDING=6;this.state=this.JOB_STATE_READY}getDomain(t){if(!t)return"";var e=t.indexOf("://")>-1?t.split("/")[2]:t.split("/")[0];e=e.split(":")[0];return e}$decodeDomainKey(t){var e,s;if(typeof TextDecoder!=="undefined"){e=CryptoJS.enc.Utf8.parse(new TextDecoder("UTF-8").decode(new Uint8Array([68,69,88,84,85,112,108,111,97,100,88,53,80,97,115,115])))}else{e=CryptoJS.lib.WordArray.create([1145395284,1433431151,1633966133,1348563827],16)}if(typeof TextDecoder!=="undefined"){s=CryptoJS.enc.Utf8.parse(new TextDecoder("UTF-8").decode(new Uint8Array([48,49,48,50,48,51,48,52,48,53,48,54,48,55,48,56])))}else{s=CryptoJS.lib.WordArray.create([808529970,808661044,808792118,808923192],16)}var r=CryptoJS.AES.decrypt(t,e,{iv:s,mode:CryptoJS.mode.CBC,padding:CryptoJS.pad.Pkcs7});var i=r.toString(CryptoJS.enc.Utf8);return i}$parseDomainLicense(t){const e={pid:"",sn:"",lic:"",max:0,domains:[],exdate:""};t?.split(/\|/).forEach(t=>{t=t.trim();if(t.toLowerCase().indexOf("pid=")==0)e.pid=t.split("=")[1].trim();if(t.toLowerCase().indexOf("sn=")==0)e.sn=t.split("=")[1].trim();if(t.toLowerCase().indexOf("licensetype=")==0)e.lic=t.split("=")[1].trim();if(t.toLowerCase().indexOf("max=")==0)e.max=parseInt(t.split("=")[1].trim(),10);if(t.toLowerCase().indexOf("domains=")==0)e.domains=t.split("=")[1].trim().split(";");if(t.toLowerCase().indexOf("expiredate=")==0)e.exdate=t.split("=")[1].trim()});return e}$isDomainValid(t,e){const{pid:s,sn:r,lic:i,max:n,domains:o,exdate:a}=t;if(!s||!r){this.onError("ESVG-00059");return false}if(s.indexOf("DNX5")!=0&&s.indexOf("ENX5")!=0){this.onError("ESVG-00059");return false}let h=0;let l=false;const c=e.toUpperCase();let u=0,d=0,p=null,S=-1;if(i=="0"){h=n}else if(i=="1"){h=2}else if(i=="2"){h=8}else if(i=="3"){h=2,l=true}else if(i=="4"){h=10;return true}else if(i=="5"){h=n}else{this.onError("ESVG-00059");return false}if(i=="0"){var m=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];var f=m[parseInt(a.substring(4,6),10)-1]+" "+a.substring(6,8)+" "+a.substring(0,4);var g=new Date(f);g.setTime(g.getTime()+864e5);if(g<=new Date){this.onError("ESVG-00061");return false}}if(c=="LOCALHOST"||c=="127.0.0.1")return true;for(u=0,d=Math.min(o.length,h),p=null,S=-1;u<d;u++){p=o[u].toUpperCase();if(l){if(p.indexOf(".")==0)p=p.substring(1);else if(p.indexOf("*.")==0)p=p.substring(2);S=c.indexOf(p);if(S==0&&c.length==p.length)return true;else if(S>0&&c.charAt(S-1)=="."&&c.length==S+p.length)return true}else if(p==c){return true}}this.onError("ESVG-00060",[c]);return false}$decodeCombinationKey(t){var e,s;if(typeof TextDecoder!=="undefined"){e=CryptoJS.enc.Utf8.parse(new TextDecoder("UTF-8").decode(new Uint8Array([68,69,88,84,67,111,109,98,105,110,101,100,80,97,115,115])))}else{e=CryptoJS.lib.WordArray.create([1145395284,1131375970,1768842596,1348563827],16)}if(typeof TextDecoder!=="undefined"){s=CryptoJS.enc.Utf8.parse(new TextDecoder("UTF-8").decode(new Uint8Array([48,49,48,50,48,51,48,52,48,53,48,54,48,55,48,56])))}else{s=CryptoJS.lib.WordArray.create([808529970,808661044,808792118,808923192],16)}var r=CryptoJS.AES.decrypt(t,e,{iv:s,mode:CryptoJS.mode.CBC,padding:CryptoJS.pad.Pkcs7});var i=r.toString(CryptoJS.enc.Utf8);return i}$parseCombinationLicense(t){const e={pid:"",sn:"",ml:0,sl:1,services:[],exdate:""};t?.split(/\|/).forEach(t=>{t=t.trim();if(t.toLowerCase().indexOf("pid=")==0)e.pid=t.split("=")[1].trim();if(t.toLowerCase().indexOf("sn=")==0)e.sn=t.split("=")[1].trim();if(t.toLowerCase().indexOf("ml=")==0)e.ml=parseInt(t.split("=")[1].trim(),10);if(t.toLowerCase().indexOf("sl=")==0)e.sl=parseInt(t.split("=")[1].trim(),10);if(t.toLowerCase().indexOf("services=")==0)e.services=t.split("=")[1].trim().split(";");if(t.toLowerCase().indexOf("expired=")==0)e.exdate=t.split("=")[1].trim()});return e}$isCombinationValid(t,e){const{pid:s,sn:r,ml:i,sl:n,services:o,exdate:a}=t;if(!s||!r){this.onError("ESVG-00059");return false}if(s.substr(0,4)!="EACP"&&s.substr(0,3)!="D5C"){this.onError("ESVG-00059");return false}const h=Math.min(o.length,n);const l=i===2;const c=e.toUpperCase();let u=0,d=null,p=-1;if(i===0){var S=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];var m=S[parseInt(a.substring(4,6),10)-1]+" "+a.substring(6,8)+" "+a.substring(0,4);var f=new Date(m);f.setTime(f.getTime()+864e5);if(f<=new Date){this.onError("ESVG-00061");return false}}if(c=="LOCALHOST"||c=="127.0.0.1")return true;for(u=0,d=null,p=-1;u<h;u++){d=o[u].toUpperCase();if(l){if(d.indexOf("*.")==0)d=d.substring(2);p=c.indexOf(d);if(p==0&&c.length==d.length)return true;else if(p>0&&c.charAt(p-1)=="."&&c.length==p+d.length)return true}else if(d==c){return true}}this.onError("ESVG-00060",[c]);return false}authenticate(t,e){var s="",r=false,i="";try{s=this.$decodeDomainKey(t);if(!s)throw Error("The decoded string is blank.")}catch(t){r=true;i=t}if(r===false&&["PID","SN"].filter(function(t,e){return s.toUpperCase().indexOf(t)>=0}).length===2){const n=this.$parseDomainLicense(s);const o=this.getDomain(window.location.hostname);if(!this.$isDomainValid(n,o))return false;const a=this.getDomain(e);return this.$isDomainValid(n,a)}else{r=false}try{s=this.$decodeCombinationKey(t);if(!s)throw Error("The decoded string is blank.")}catch(t){r=true;i=t}if(r===false&&["PID","SN"].filter(function(t,e){return s.toUpperCase().indexOf(t)>=0}).length===2){const h=this.$parseCombinationLicense(s);const o=this.getDomain(window.location.hostname);if(!this.$isCombinationValid(h,o))return false;const a=this.getDomain(e);return this.$isCombinationValid(h,a)}else{this.onError("ESVG-00081",[i.message]);return false}}saveData(t,e,s,r,i,n){if(isHttpURL(t)){return n("ESVG-00068",[t])}var o=window,a=r?r.contentDocument:o.document,h=a.createElementNS("http://www.w3.org/1999/xhtml","a"),l="download"in h,c=o.URL||o.webkitURL||o,u=function(t){t.dispatchEvent(new MouseEvent("click"))},d=null;s=s||"application/octet-stream";e=e||"download";i=typeof i==="function"?i:function(){};n=typeof n==="function"?n:function(t,e){};if(o.navigator.msSaveBlob){d=d2b(o,t,s);if(o.navigator.msSaveBlob(d,e))i();else n()}else if(l===true){d=d2b(o,t,s);var p=c.createObjectURL(d);h.href=p;h.download=e;a.body.appendChild(h);u(h);a.body.removeChild(h);setTimeout(function(){c.revokeObjectURL(p)},1e3*3);h=null;i()}else{n("ESVG-00067",undefined)}}}class UploadTransfer extends CommonTransfer{constructor(t,e,s,r={}){super();this.isDoneResponse=false;this.status=new DX5UploadStatus;this.result=e;this.upQueue=s;this.customHeaders=r;this.licenseKey=t.licenseKey;this.uploadUrl=t.uploadUrl;this.isPHP=t.isPHP;this.chunkedBlock=t.chunkedBlock;this.splitString=t.splitString;this.emptyString=t.emeptyString;this.resumingUpload=t.resumingUpload;this.credential=t.credentials;this.onerror=t.onUpError.bind(t);this.onbegin=t.onbeginUpload.bind(t);this.onprogress=t.onprogressUpload.bind(t);this.oncomplete=t.oncompleteUpload.bind(t);this.onitemstart=t.onstartUploadItem.bind(t);this.onitemend=t.onendUploadItem.bind(t);this.onabort=t.onabortUpload.bind(t);this.oncancel=t.oncancelUpload.bind(t)}onError(t,e=[]){this.state=this.JOB_STATE_ERROR;this.onerror&&typeof this.onerror==="function"&&this.onerror(t,e)}onBegin(t){this.state=this.JOB_STATE_PROCESSING;this.onbegin&&typeof this.onbegin==="function"&&this.onbegin(t)}onItemStart(t){this.onitemstart&&typeof this.onitemstart==="function"&&this.onitemstart(t)}onProgress(t){this.onprogress&&typeof this.onprogress==="function"&&this.onprogress(t)}onItemEnd(t,e){this.onitemend&&typeof this.onitemend==="function"&&this.onitemend(t,e)}onComplete(){this.state=this.JOB_STATE_DONE;this.oncomplete&&typeof this.oncomplete==="function"&&this.oncomplete(this.result)}onAbort(){this.state=this.JOB_STATE_ABORT;this.onabort&&typeof this.onabort==="function"&&this.onabort()}onCancel(){this.state=this.JOB_STATE_CANCEL;this.oncancel&&typeof this.oncancel==="function"&&this.oncancel()}makeMetaString(e,s){var r=[];for(let t in e){if(Object.hasOwn(e,t)){r.push(`${t}${s}${e[t]}`)}}return r.join(this.splitString)}}class ORAFTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i)}transfer(){if(this.upQueue.length==0){return}const r=this.status,t=new FormData;const i=this.upQueue.length;const n=this;t.append("DEXTUploadX5_AuthKey",this.licenseKey);for(var e=0,s=null;e<i;e++){s=this.upQueue[e];t.append(this.isPHP?"DEXTUploadX5_ControlId[]":"DEXTUploadX5_ControlId",s.controlId);t.append(this.isPHP?"DEXTUploadX5_UniqueId[]":"DEXTUploadX5_UniqueId",s.id);t.append(this.isPHP?"DEXTUploadX5_Folder[]":"DEXTUploadX5_Folder",s.middlePath);t.append(this.isPHP?"DEXTUploadX5_EXIFData[]":"DEXTUploadX5_EXIFData","");t.append(this.isPHP?"DEXTUploadX5_FileData[]":"DEXTUploadX5_FileData",s.ofile,s.name);t.append(this.isPHP?"DEXTUploadX5_MetaData[]":"DEXTUploadX5_MetaData",this.makeMetaString(s.meta,this.splitString))}const o=this.upQueue[0].name+(i>1?" + "+(i-1)+" file(s)":"");r.setItem(null,o,this.upQueue.getTotalSize());r.progress.change(0,this.upQueue.getTotalSize());r.xhr=requestUpload(this.uploadUrl,t,{credential:this.credential===true,headers:this.customHeaders},{start:t=>{r.start();n.onItemStart(r)},progress:t=>{if(t.lengthComputable){r.progress.updateFileProgress(t.total,t.loaded);n.onProgress(r)}},load:(t,e)=>{r.progress.updateFileProgress(t.total,t.loaded);n.onProgress(r);for(var s=0;s<i;s++){n.upQueue[s].status="DONE";n.upQueue[s].update()}r.progress.wrapup(true);n.result.push({id:"",response:e});n.onItemEnd(r,e)},end:t=>{r.xhr=null;n.isDoneResponse=true;if(t.readyState==4&&t.status==200){n.onComplete()}},abort:t=>{console.warn("DX5: "+r.progress.currentName+" uploading aborted.");if(r.cancelFlag)n.onCancel();else if(r.abortFlag)n.onAbort()},timeout:t=>{console.error("DX5: "+r.progress.currentName+" uploading timeout.");n.onError("ESVG-00018",["ORAF Target: "+n.uploadUrl,"Upload timeout",""],true)},error:(t,e,s)=>{console.error("DX5: "+r.progress.currentName+" uploading error occured.");n.onError("ESVG-00019",["ORAF Target: "+n.uploadUrl,t,e,s])}})}upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");if(!this.authenticate(this.licenseKey,this.uploadUrl))return;const t=this.status;t.init("ORAF",this.upQueue.getTotalSize(),1);this.onBegin(t);this.transfer()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.cancelFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.abortFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){const t=this.status;t.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;this.transfer()}}}class OROFTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i);this.uploadTimeInterval=t.uploadTimeInterval}transfer(t=false){const r=this.status;const i=this;if(r.cancelFlag)return this.onCancel();else if(r.abortFlag)return this.onAbort();let e=null;if(t&&r.isNotCurrentFinished()){e=r.currentItem}else{if(this.upQueue.length==0)return;e=this.upQueue.shift();r.setItem(e);r.progress.change(0,e.size)}const s=new FormData;s.append("DEXTUploadX5_AuthKey",this.licenseKey);s.append("DEXTUploadX5_ControlId",e.controlId);s.append("DEXTUploadX5_UniqueId",e.id);s.append("DEXTUploadX5_Folder",e.middlePath);s.append("DEXTUploadX5_EXIFData","");s.append("DEXTUploadX5_FileData",e.ofile,e.name);s.append("DEXTUploadX5_MetaData",this.makeMetaString(e.meta,this.splitString));r.xhr=requestUpload(this.uploadUrl,s,{credential:this.credential===true,headers:this.customHeaders},{start:t=>{r.start();i.onItemStart(r)},progress:t=>{if(t.lengthComputable){r.progress.updateFileProgress(t.total,t.loaded);i.onProgress(r)}},load:(t,e)=>{r.progress.updateFileProgress(t.total,t.loaded);i.onProgress(r);r.currentItem.status="DONE";r.currentItem.update();r.progress.wrapup(true);i.result.push({id:r.currentItem.id,response:e});i.onItemEnd(r,e)},end:t=>{r.xhr=null;if(t.readyState==4&&t.status==200){if(i.upQueue.length==0){i.isDoneResponse=true;i.onComplete()}else{setTimeout(t=>i.transfer(false),i.uploadTimeInterval)}}},abort:t=>{console.warn("DX5: "+r.progress.currentName+" uploading aborted.");if(r.cancelFlag)i.onCancel();else if(r.abortFlag)i.onAbort()},timeout:t=>{console.error("DX5: "+r.progress.currentName+" uploading timeout.");i.onError("ESVG-00018",["OROF Target: "+i.uploadUrl,"Upload timeout",""],true)},error:(t,e,s)=>{console.error("DX5: "+r.progress.currentName+" uploading error occured.");i.onError("ESVG-00019",["OROF Target: "+i.uploadUrl,t,e,s])}})}upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");if(!this.authenticate(this.licenseKey,this.uploadUrl))return;const t=this.status;t.init("OROF",this.upQueue.getTotalSize(),this.upQueue.length);this.onBegin(t);this.transfer()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.cancelFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.abortFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){const t=this.status;t.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;this.transfer(true)}}}class ExtensionTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i);this.chunkedBlock=t.chunkedBlock;this.uploadTimeInterval=t.uploadTimeInterval;this.useChecksum=t.useChecksum;this.checksumWorker=null;this.storage=window.localStorage;this.onmakehash=t.onprogressUpload.bind(t)}onMakeHash(t){this.onmakehash&&typeof this.onmakehash==="function"&&this.onmakehash(t)}makeLocalKey(t){return encodeURIComponent(t.name)+t.size+t.mdate.getTime().toString()}lookupServerKey(t){return this.storage.getItem(t)||""}storeServerKey(t,e){try{this.storage.setItem(t,e);return true}catch(t){return false}}removeServerKey(t){try{this.storage.removeItem(t)}catch(t){}}parseExtensionResponse(t){const e=t.match(/\s*key\s*=\s*(.*)\s*[;]{1}\s*size\s*=\s*(.*)\s*/i);return e?{key:trim(e[1]),size:parseInt(trim(e[2]),10)}:null}calculateNextRange(t,e,s){const r=e-s;const i=Math.min(t,r);const n=r-i==0;return{start:s,end:s+i,chunk:i,isLast:n}}transferChunk(r,i){const n=this;r.xhr=requestUpload(this.uploadUrl,i,{credential:this.credential===true,headers:this.customHeaders},{start:t=>{r.start();r.currentChunkedAction=="P"&&n.onItemStart(r)},progress:t=>{if(t.lengthComputable&&r.isAttaching()){r.progress.updateFileProgress(t.total,t.loaded);n.onProgress(r)}},load:(t,e)=>{if(!r.isPreparation()){r.progress.updateFileProgress(t.total,t.loaded);n.onProgress(r)}r.currentResponseValue=trim(e);r.progress.wrapup(r.isDone());if(r.isDone()){r.currentItem.status="DONE";r.currentItem.update();n.result.push({id:r.currentItem.id,response:e});n.removeServerKey(r.currentLocalKey);n.onItemEnd(r,e)}},end:t=>{r.xhr=null;if(t.readyState==4&&t.status==200){if(n.upQueue.length==0&&r.isDone()){n.isDoneResponse=true;n.onComplete()}else{r.switchAction();setTimeout(t=>n.transfer(false),n.uploadTimeInterval)}}},abort:t=>{console.warn(`DX5: ${r.progress.currentName} uploading aborted.`);r.switchAction("P");if(r.cancelFlag)n.onCancel();else if(r.abortFlag)n.onAbort()},timeout:t=>{console.error(`DX5: ${r.progress.currentName} uploading timeout.`);r.switchAction("P");n.onError("ESVG-00018",["EXTS Target: "+n.uploadUrl,"Upload timeout",""])},error:(t,e,s)=>{console.error(`DX5: ${r.progress.currentName} uploading error occured.`);r.switchAction("P");n.onError("ESVG-00019",["EXTS Target: "+n.uploadUrl,t,e,i.get("DEXT_EXTENSION_ACTION")+"\n"+s])}})}transfer(t=false){const e=this.status;const s=this;if(e.cancelFlag){e.switchAction("P");return this.onCancel()}else if(e.abortFlag){e.switchAction("P");return this.onAbort()}let r=null;if(e.isPreparation()){if(t&&e.isNotCurrentFinished()){r=e.currentItem}else{if(this.upQueue.length==0)return;r=this.upQueue.shift();e.setItem(r);e.currentLocalKey=this.makeLocalKey(r)}const n=new FormData;n.append("DEXTUploadX5_AuthKey",this.licenseKey);n.append("DEXT_EXTENSION_ACTION",sformat("type=preparing\r\nkey={0}\r\nname={1}\r\nlocal=/dx5fakepath/{2}\r\nsize={3}\r\nmodified={4}",[this.resumingUpload===true?this.lookupServerKey(e.currentLocalKey):"",r.name,r.name,r.size,r.mdate.getTime()]));this.transferChunk(e,n)}else{let t=this.parseExtensionResponse(e.currentResponseValue);if(t===null){return this.onError("ESVG-00074",[e.currentResponseValue])}if(e.isRepeated(t.size)){return this.onError("ESVG-00095",[e.currentResponseValue])}if(this.resumingUpload===true)if(!this.storeServerKey(e.currentLocalKey,t.key)){return this.onError("ESVG-00018",["Type: EXTS","Target-key: "+t.key,"QUOTA_EXCEEDED_ERR"])}r=e.currentItem;const o=this.calculateNextRange(this.chunkedBlock,r.size,t.size);e.progress.change(t.size,o.chunk);var i=e.currentItem.ofile.slice(o.start,o.end);const n=new FormData;n.append("DEXTUploadX5_AuthKey",this.licenseKey);n.append("DEXT_EXTENSION_ACTION",sformat("type=attaching\r\nkey={0}\r\nname={1}\r\nlocal=/dx5fakepath/{2}\r\nsize={3}\r\nmodified={4}",[t.key,r.name,r.name,r.size,r.mdate.getTime()]));n.append("DEXTUploadX5_ControlId",r.controlId);n.append("DEXTUploadX5_UniqueId",r.id);n.append("DEXTUploadX5_Folder",r.middlePath);n.append("DEXTUploadX5_EXIFData","");n.append("DEXT_CHECKSUM_HASH","");n.append("DEXTUploadX5_FileData",i,r.name);if(o.isLast){n.append("DEXTUploadX5_MetaData",this.makeMetaString(r.meta,this.splitString))}e.switchAction(o.isLast?"D":"A");if(this.useChecksum){if(!this.checksumWorker)this.checksumWorker=new Worker("dextuploadx5-worker-checksum.js");this.checksumWorker.onmessage=null;this.checksumWorker.onerror=null;this.checksumWorker.onmessage=function(t){e.progress.updateHashProgress(t.data.total,t.data.no);if(t.data.done){n.set("DEXT_CHECKSUM_HASH",t.data.value);s.transferChunk(e,n)}else{s.onMakeHash(e)}};this.checksumWorker.onerror=t=>s.onError("ESVG-00091",[t.message]);this.checksumWorker.postMessage({file:i})}else{this.transferChunk(e,n)}}}upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");if(!this.authenticate(this.licenseKey,this.uploadUrl))return;const t=this.status;t.init("EXTS",this.upQueue.getTotalSize(),this.upQueue.length);this.onBegin(t);this.transfer()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.cancelFlag=true;this.state=this.JOB_STATE_PENDING;if(this.useChecksum&&this.checksumWorker){this.checksumWorker.terminate();this.checksumWorker=null}t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.abortFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){const t=this.status;t.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;this.transfer(true)}}}class AWSS3UploadTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i);const n=t.awsS3Configuration.upload;this.AWS_SDK_URL=n.sdkURL?n.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.uploadTimeInterval=t.uploadTimeInterval;this.storage=window.localStorage;this.awsS3Config=Object.assign({type:"SECRET",initURL:"",signedURL:"",completeURL:"",cancelURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",storageClass:"STANDARD",acl:"private",chunkSize:10*1024*1024,makeKey:t=>t.name},n);this.storage=window.localStorage;this.abortController=null;this.isAuthenticated=false}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK."));document.documentElement.appendChild(s)}})}$makeLocalKey(t){return`AWSS3:${encodeURIComponent(t.name)}${t.size}${t.mdate.getTime().toString()}`}$lookupUploadStepData(t){const e=this.storage.getItem(t)||"";return e===""?null:JSON.parse(e)}$storeUploadStepData(t,e,s){try{this.storage.setItem(t,JSON.stringify({uid:e,parts:s}));return true}catch(t){return false}}$removeUploadStepData(t){try{this.storage.removeItem(t)}catch(t){}}async $transferNonSecret(i=false){const n=this.status;const o=new window.AWS.S3;const a=this.awsS3Config;const h=this.awsS3Config.chunkSize;this.abortController=new AbortController;const l=this.abortController.signal;if(this.isAuthenticated===false){const t=this.authenticate(this.licenseKey,`https://${encodeURIComponent(a.bucket)}.s3.${a.region}.amazonaws.com`);if(t)this.isAuthenticated=true;else return}while(this.upQueue.length>0){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const c=this.upQueue[0];const u=this.$makeLocalKey(c);let e=[];let s=a.makeKey(c);let r=null;n.setItem(c);n.start();try{let t=this.$lookupUploadStepData(u);if(this.resumingUpload===true&&t){r=t.uid;e=t.parts}else{const f=Object.fromEntries(Object.entries(c.meta).map(([t,e])=>[t,rfc2047Encode(e.toString())]));const g=await o.createMultipartUpload({Bucket:a.bucket,Key:s,StorageClass:a.storageClass,ACL:a.acl,Metadata:f}).promise();r=g.UploadId}this.onItemStart(n);const d=c.ofile.size;const p=e.map(t=>t.PartNumber);for(let t=0;t<d;t+=h){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const E=Math.min(h,d-t);const T=t+E;const w=Math.ceil(t/h)+1;if(p.includes(w))continue;n.progress.change(t,E);this.onProgress(n);const A=await o.uploadPart({Bucket:a.bucket,Key:s,PartNumber:w,UploadId:r,Body:c.ofile.slice(t,T)}).promise();e.push({PartNumber:w,ETag:A.ETag});n.progress.updateFileProgress(d,t+E);this.onProgress(n);this.resumingUpload===true&&this.$storeUploadStepData(u,r,e)}const S=await o.completeMultipartUpload({Bucket:a.bucket,Key:s,UploadId:r,MultipartUpload:{Parts:e}}).promise();this.$removeUploadStepData(u);const m=S.Location;this.upQueue.shift();c.status="DONE";c.update();n.progress.wrapup(true);this.result.push({id:c.id,response:m});this.onItemEnd(n,m)}catch(t){if(l.aborted&&n.cancelFlag===true)return this.onCancel();else if(l.aborted&&n.abortFlag===true)return this.onAbort();else if(t.code&&t.code.toLowerCase()==="nosuchupload"&&i===false){this.$removeUploadStepData(u);return this.$transferNonSecret(true)}else return this.onError("ESVG-00018",["AWSS3 NON-SECRET mode",s,t.message])}}this.isDoneResponse=true;this.onComplete()}async $fetch(e,s,t){const r=s==="POST"?await fetch(e,{method:s,body:t,headers:{"Content-Type":"application/x-www-form-urlencoded"}}):await fetch(e,{method:s});if(r.ok){return r.json()}else{await r.text().then(t=>{throw new Error(`${s}-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $initMultiPartUpload(t,e,s,r,i,n){const o=new URLSearchParams;o.append("key",e);o.append("acl",s);o.append("sclass",r);o.append("type",i);o.append("metadata",JSON.stringify(n));return await this.$fetch(t,"POST",o.toString())}async $getPreSignedURL(t,e,s,r){const i=new URLSearchParams;i.append("key",e);i.append("uid",s);i.append("pnum",r);return await this.$fetch(t,"POST",i.toString())}async $uploadPart(e,t,s){const r=await fetch(e,{method:"PUT",headers:{"Content-Type":s},body:t});if(r.ok){return r.headers.get("ETag")}else{await r.text().then(t=>{throw new Error(`PUT-PART-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $completeMultiPartUpload(t,e,s,r){const i=new URLSearchParams;i.append("key",e);i.append("uid",s);for(const n of r){i.append("pnum",n.PartNumber);i.append("etag",n.ETag)}return await this.$fetch(t,"POST",i.toString())}async $abortMultiPartUpload(t,e,s){const r=new URLSearchParams;r.append("key",e);r.append("uid",s);await this.$fetch(t,"POST",r.toString())}async $transferSecret(i=false){const n=this.status;const o=this.awsS3Config;const a=this.awsS3Config.chunkSize;this.abortController=new AbortController;const h=this.abortController.signal;while(this.upQueue.length>0){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const l=this.upQueue[0];const c=Object.fromEntries(Object.entries(l.meta).map(([t,e])=>[t,rfc2047Encode(e.toString())]));const u=this.$makeLocalKey(l);let e=[];let s=o.makeKey(l);let r=null;n.setItem(l);n.start();try{let t=this.$lookupUploadStepData(u);if(this.resumingUpload===true&&t){r=t.uid;e=t.parts}else{const f=await this.$initMultiPartUpload(o.initURL,s,o.acl,o.storageClass,l.ofile.type,c);r=f.uid;s=f.key}this.onItemStart(n);const d=l.ofile.size;const p=e.map(t=>t.PartNumber);for(let t=0;t<d;t+=a){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const g=Math.min(a,d-t);const E=t+g;const T=Math.ceil(t/a)+1;if(p.includes(T))continue;n.progress.change(t,g);this.onProgress(n);const w=await this.$getPreSignedURL(o.signedURL,s,r,T);if(this.isAuthenticated===false){const C=this.authenticate(this.licenseKey,w.url);if(C)this.isAuthenticated=true;else return}const A=await this.$uploadPart(w.url,l.ofile.slice(t,E),l.ofile.type||"application/octet-stream");e.push({PartNumber:T,ETag:A});n.progress.updateFileProgress(d,t+g);this.onProgress(n);this.resumingUpload===true&&this.$storeUploadStepData(u,r,e)}const S=await this.$completeMultiPartUpload(o.completeURL,s,r,e);this.$removeUploadStepData(u);const m=S.location;this.upQueue.shift();l.status="DONE";l.update();n.progress.wrapup(true);this.result.push({id:l.id,response:m});this.onItemEnd(n,m)}catch(t){if(h.aborted&&n.cancelFlag===true)return this.onCancel();else if(h.aborted&&n.abortFlag===true)return this.onAbort();else if(t.code&&t.code.toLowerCase()==="nosuchupload"&&i===false){this.$removeUploadStepData(u);return this.$transferSecret(true)}else return this.onError("ESVG-00018",["AWSS3 SECRET mode",s,t.message])}}this.isDoneResponse=true;this.onComplete()}async upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");const t=this.awsS3Config;try{if(t.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:t.accessKeyId,secretAccessKey:t.secretAccessKey,region:t.region})}}catch(t){return this.onError("ESVG-00104")}const e=this.status;e.init("AWSS3",this.upQueue.getTotalSize(),this.upQueue.length);this.onBegin(e);if(t.type==="NON-SECRET")this.$transferNonSecret();else this.$transferSecret()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{this.status.cancelFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{this.status.abortFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){const t=this.awsS3Config;if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){this.status.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;if(t.type==="NON-SECRET")this.$transferNonSecret();else this.$transferSecret()}}}class NCPOSUploadTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i);const n=t.ncpOSConfiguration.upload;this.AWS_SDK_URL=n.sdkURL?n.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.uploadTimeInterval=t.uploadTimeInterval;this.storage=window.localStorage;this.ncpOSConfig=Object.assign({type:"SECRET",initURL:"",signedURL:"",completeURL:"",cancelURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",storageClass:"STANDARD",acl:"private",chunkSize:10*1024*1024,makeKey:t=>t.name},n);this.storage=window.localStorage;this.abortController=null;this.isAuthenticated=false}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK for NCPOS."));document.documentElement.appendChild(s)}})}$makeLocalKey(t){return`NCPOS:${encodeURIComponent(t.name)}${t.size}${t.mdate.getTime().toString()}`}$lookupUploadStepData(t){const e=this.storage.getItem(t)||"";return e===""?null:JSON.parse(e)}$storeUploadStepData(t,e,s){try{this.storage.setItem(t,JSON.stringify({uid:e,parts:s}));return true}catch(t){return false}}$removeUploadStepData(t){try{this.storage.removeItem(t)}catch(t){}}async $transferNonSecret(i=false){const n=this.status;const o=new window.AWS.S3;const a=this.ncpOSConfig;const h=this.ncpOSConfig.chunkSize;this.abortController=new AbortController;const l=this.abortController.signal;if(this.isAuthenticated===false){const t=this.authenticate(this.licenseKey,`https://${encodeURIComponent(a.bucket)}.${a.region}.object.ncloudstorage.com`);if(t)this.isAuthenticated=true;else return}while(this.upQueue.length>0){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const c=this.upQueue[0];const u=this.$makeLocalKey(c);let e=[];let s=a.makeKey(c);let r=null;n.setItem(c);n.start();try{let t=this.$lookupUploadStepData(u);if(this.resumingUpload===true&&t){r=t.uid;e=t.parts}else{const f=Object.fromEntries(Object.entries(c.meta).map(([t,e])=>[t,rfc2047Encode(e.toString())]));const g=await o.createMultipartUpload({Bucket:a.bucket,Key:s,StorageClass:"STANDARD",ACL:a.acl,Metadata:f}).promise();r=g.UploadId}this.onItemStart(n);const d=c.ofile.size;const p=e.map(t=>t.PartNumber);for(let t=0;t<d;t+=h){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const E=Math.min(h,d-t);const T=t+E;const w=Math.ceil(t/h)+1;if(p.includes(w))continue;n.progress.change(t,E);this.onProgress(n);const A=await o.uploadPart({Bucket:a.bucket,Key:s,PartNumber:w,UploadId:r,Body:c.ofile.slice(t,T)}).promise();e.push({PartNumber:w,ETag:A.ETag});n.progress.updateFileProgress(d,t+E);this.onProgress(n);this.resumingUpload===true&&this.$storeUploadStepData(u,r,e)}const S=await o.completeMultipartUpload({Bucket:a.bucket,Key:s,UploadId:r,MultipartUpload:{Parts:e}}).promise();this.$removeUploadStepData(u);const m=S.Location;this.upQueue.shift();c.status="DONE";c.update();n.progress.wrapup(true);this.result.push({id:c.id,response:m});this.onItemEnd(n,m)}catch(t){if(l.aborted&&n.cancelFlag===true)return this.onCancel();else if(l.aborted&&n.abortFlag===true)return this.onAbort();else if(t.code&&t.code.toLowerCase()==="nosuchupload"&&i===false){this.$removeUploadStepData(u);return this.$transferNonSecret(true)}else return this.onError("ESVG-00018",["NCPOS NON-SECRET mode",s,t.message])}}this.isDoneResponse=true;this.onComplete()}async $fetch(e,s,t){const r=s==="POST"?await fetch(e,{method:s,body:t,headers:{"Content-Type":"application/x-www-form-urlencoded"}}):await fetch(e,{method:s});if(r.ok){return r.json()}else{await r.text().then(t=>{throw new Error(`${s}-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $initMultiPartUpload(t,e,s,r,i,n){const o=new URLSearchParams;o.append("key",e);o.append("acl",s);o.append("sclass",r);o.append("type",i);o.append("metadata",JSON.stringify(n));return await this.$fetch(t,"POST",o.toString())}async $getPreSignedURL(t,e,s,r){const i=new URLSearchParams;i.append("key",e);i.append("uid",s);i.append("pnum",r);return await this.$fetch(t,"POST",i.toString())}async $uploadPart(e,t,s){const r=await fetch(e,{method:"PUT",headers:{"Content-Type":s},body:t});if(r.ok){return r.headers.get("ETag")}else{await r.text().then(t=>{throw new Error(`PUT-PART-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $completeMultiPartUpload(t,e,s,r){const i=new URLSearchParams;i.append("key",e);i.append("uid",s);for(const n of r){i.append("pnum",n.PartNumber);i.append("etag",n.ETag)}return await this.$fetch(t,"POST",i.toString())}async $abortMultiPartUpload(t,e,s){const r=new URLSearchParams;r.append("key",e);r.append("uid",s);await this.$fetch(t,"POST",r.toString())}async $transferSecret(i=false){const n=this.status;const o=this.ncpOSConfig;const a=this.ncpOSConfig.chunkSize;this.abortController=new AbortController;const h=this.abortController.signal;while(this.upQueue.length>0){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const l=this.upQueue[0];const c=Object.fromEntries(Object.entries(l.meta).map(([t,e])=>[t,rfc2047Encode(e.toString())]));const u=this.$makeLocalKey(l);let e=[];let s=o.makeKey(l);let r=null;n.setItem(l);n.start();try{let t=this.$lookupUploadStepData(u);if(this.resumingUpload===true&&t){r=t.uid;e=t.parts}else{const f=await this.$initMultiPartUpload(o.initURL,s,o.acl,o.storageClass,l.ofile.type,c);r=f.uid;s=f.key}this.onItemStart(n);const d=l.ofile.size;const p=e.map(t=>t.PartNumber);for(let t=0;t<d;t+=a){if(n.cancelFlag)return this.onCancel();else if(n.abortFlag)return this.onAbort();const g=Math.min(a,d-t);const E=t+g;const T=Math.ceil(t/a)+1;if(p.includes(T))continue;n.progress.change(t,g);this.onProgress(n);const w=await this.$getPreSignedURL(o.signedURL,s,r,T);if(this.isAuthenticated===false){const C=this.authenticate(this.licenseKey,w.url);if(C)this.isAuthenticated=true;else return}const A=await this.$uploadPart(w.url,l.ofile.slice(t,E),l.ofile.type||"application/octet-stream");e.push({PartNumber:T,ETag:A});n.progress.updateFileProgress(d,t+g);this.onProgress(n);this.resumingUpload===true&&this.$storeUploadStepData(u,r,e)}const S=await this.$completeMultiPartUpload(o.completeURL,s,r,e);this.$removeUploadStepData(u);const m=S.location;this.upQueue.shift();l.status="DONE";l.update();n.progress.wrapup(true);this.result.push({id:l.id,response:m});this.onItemEnd(n,m)}catch(t){if(h.aborted&&n.cancelFlag===true)return this.onCancel();else if(h.aborted&&n.abortFlag===true)return this.onAbort();else if(t.code&&t.code.toLowerCase()==="nosuchupload"&&i===false){this.$removeUploadStepData(u);return this.$transferSecret(true)}else return this.onError("ESVG-00018",["NCPOS SECRET mode",s,t.message])}}this.isDoneResponse=true;this.onComplete()}async upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");const t=this.ncpOSConfig;try{if(t.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:t.accessKeyId,secretAccessKey:t.secretAccessKey,region:t.region,endpoint:`https://${t.region}.object.ncloudstorage.com`,signatureVersion:"v4"})}}catch(t){return this.onError("ESVG-00104")}const e=this.status;e.init("NCPOS",this.upQueue.getTotalSize(),this.upQueue.length);this.onBegin(e);if(t.type==="NON-SECRET")this.$transferNonSecret();else this.$transferSecret()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{this.status.cancelFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{this.status.abortFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){const t=this.ncpOSConfig;if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){this.status.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;if(t.type==="NON-SECRET")this.$transferNonSecret();else this.$transferSecret()}}}class AzureBlobUploadTransfer extends UploadTransfer{constructor(t,e,s,r,i={}){super(t,e,s,r,i);const n=t.azrbsConfiguration.upload;this.uploadTimeInterval=t.uploadTimeInterval;this.storage=window.localStorage;this.azrbsConfig=Object.assign({accountName:"",containerName:"",sasListURL:"",sasUploadURL:"",blockSize:10*1024*1024,makeKey:t=>t.name},n);this.abortController=null;this.isAuthenticated=false}$makeLocalKey(t){return`AZRBS:${encodeURIComponent(t.name)}${t.size}${t.mdate.getTime().toString()}`}$lookupUploadStepData(t){const e=this.storage.getItem(t)||"";return e===""?[]:JSON.parse(e)}$storeUploadStepData(t,e){try{this.storage.setItem(t,JSON.stringify(e));return true}catch(t){return false}}$removeUploadStepData(t){try{this.storage.removeItem(t)}catch(t){}}async $fetch(e,t,s){const r=t==="POST"?await fetch(e,{method:t,body:s,headers:{"Content-Type":"application/x-www-form-urlencoded"},signal:this.abortController?.signal,credentials:this.credential?"include":"same-origin"}):await fetch(e,{method:t,signal:this.abortController?.signal,credentials:this.credential?"include":"same-origin"});if(r.ok){return r.text()}else{await r.text().then(t=>{throw new Error(`FETCH-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $getUncommittedBlocks(t,e){const s=new URLSearchParams;s.append("key",e);const r=await this.$fetch(this.azrbsConfig.sasListURL,"POST",s.toString());const i=`${t}?comp=blocklist&blocklisttype=uncommitted&${r}`;const n=await this.$fetch(i);const o=new DOMParser;const a=o.parseFromString(n,"application/xml");const h=a.getElementsByTagName("Block");const l=new Set;for(let t=0;t<h.length;t++){const c=h[t];const u=c.getElementsByTagName("Name")[0]?.textContent.trim();const d=c.getElementsByTagName("Size")[0]?.textContent.trim();if(!u||!d)continue;try{const p=atob(u);const S=parseInt(p,10);const m=parseInt(d,10);if(!isNaN(S)&&!isNaN(m)){l.add(`${S.toString().padStart(6,"0")}:${m}`)}}catch(t){throw new Error(`Failed to decode block name: ${u}. Error: ${t.message}`)}}return l}async $getUploadSasToken(){return await this.$fetch(this.azrbsConfig.sasUploadURL)}async $uploadPart(e,t,s){const r=await fetch(e,{method:"PUT",headers:{"x-ms-blob-type":"BlockBlob","Content-Type":s},body:t,signal:this.abortController?.signal});if(r.ok){}else{await r.text().then(t=>{throw new Error(`PUT-PART-URL: ${e}\nStatus/Code: ${r.status.toString()}\n${t}`)})}}async $commitAllParts(e,t,s,r){const i={"x-ms-blob-content-type":s,"Content-Type":"application/xml"};if(r){i["x-ms-access-tier"]=r}const n=await fetch(e,{method:"PUT",headers:i,body:`<?xml version="1.0" encoding="utf-8"?><BlockList>${t.map(t=>`<Latest>${btoa(t.toString().padStart(6,"0"))}</Latest>`).join("")}</BlockList>`});if(n.ok){}else{await n.text().then(t=>{throw new Error(`PUT-COMMIT-URL: ${e}\nStatus/Code: ${n.status.toString()}\n${t}`)})}}async $uploadMetadata(e,t){const s=await fetch(e,{method:"PUT",headers:{...t}});if(s.ok){}else{await s.text().then(t=>{throw new Error(`PUT-METADATA-URL: ${e}\nStatus/Code: ${s.status.toString()}\n${t}`)})}}async $transfer(){const e=this.status;const t=this.azrbsConfig;const s=t.blockSize;this.abortController=new AbortController;const r=this.abortController.signal;while(this.upQueue.length>0){if(e.cancelFlag)return this.onCancel();else if(e.abortFlag)return this.onAbort();const i=this.upQueue[0];const n=this.$makeLocalKey(i);const o=t.makeKey(i);const a=[];e.setItem(i);e.start();try{const h=`https://${t.accountName}.blob.core.windows.net/${t.containerName}/${encodeURIComponent(o)}`;if(this.isAuthenticated===false){const m=this.authenticate(this.licenseKey,h);if(m)this.isAuthenticated=true;else return}const l=this.$lookupUploadStepData(n);if(this.resumingUpload===true&&Array.isArray(l)&&l.length>0){const f=await this.$getUncommittedBlocks(h,o);l.sort();if(l.every(t=>{const e=f.has(t);if(e){t=t.split(":");const s=parseInt(t[0],10);a.push(s)}return e})){a.sort()}else{this.$removeUploadStepData(n);a.length=0}}this.onItemStart(e);const c=i.ofile.size;const u=Math.ceil(c/s);for(let t=0;t<u;t++){if(e.cancelFlag)return this.onCancel();else if(e.abortFlag)return this.onAbort();else if(a.includes(t))continue;const g=await this.$getUploadSasToken();const E=t*s;const T=Math.min(E+s,c);const w=T-E;const A=`${h}?comp=block&blockid=${btoa(t.toString().padStart(6,"0"))}&${g}`;e.progress.change(E,w);this.onProgress(e);await this.$uploadPart(A,i.ofile.slice(E,T),i.ofile.type||"application/octet-stream");e.progress.updateFileProgress(c,T);this.onProgress(e);a.push(t);if(this.resumingUpload===true){l.push(`${t.toString().padStart(6,"0")}:${w}`);this.$storeUploadStepData(n,l)}}a.sort();const d=await this.$getUploadSasToken();const p=`${h}?comp=blocklist&${d}`;await this.$commitAllParts(p,a,i.ofile.type||"application/octet-stream",t.accessTier);const S=Object.fromEntries(Object.entries(i.meta).map(([t,e])=>[`x-ms-meta-${t}`,rfc2047Encode(e.toString())]));if(Object.keys(S).length>0){const C=await this.$getUploadSasToken();const O=`${h}?comp=metadata&${C}`;await this.$uploadMetadata(O,S)}this.$removeUploadStepData(n);this.upQueue.shift();i.status="DONE";i.update();e.progress.wrapup(true);this.result.push({id:i.id,response:h});this.onItemEnd(e,h)}catch(t){if(r.aborted&&e.cancelFlag===true)return this.onCancel();else if(r.aborted&&e.abortFlag===true)return this.onAbort();else return this.onError("ESVG-00018",["AZRBS mode",o,t.message])}}this.isDoneResponse=true;this.onComplete()}async upload(){if(this.state!==this.JOB_STATE_READY)return this.onError("ESVG-00024");const t=this.status;t.init("AZRBS",this.upQueue.getTotalSize(),this.upQueue.length);this.onBegin(t);this.$transfer()}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{this.status.cancelFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{this.status.abortFlag=true;this.state=this.JOB_STATE_PENDING;this.abortController?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){this.status.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;this.$transfer()}}}class SingleDownTransfer extends CommonTransfer{constructor(t,e){super();this.licenseKey=t.licenseKey;this.downItem=e;this.downObjects=t.downObjects;this.downloadHeadRequest=t.downloadHeadRequest;this.onerror=t.onDownError.bind(t)}onError(t,e=[]){this.onerror&&typeof this.onerror==="function"&&this.onerror(t,e)}downloadURL(t,e){const s=this.downObjects.button;if("download"in s){s.href=t;if(e)s.download=e;s.click()}else{this.downObjects.iframe.src=t}}async downloadResource(){const e=this;const{name:t,url:s}=this.downItem;if(!s)return this.onError("ESVG-00040");if(this.authenticate(this.licenseKey,s)!=true)return;try{if(this.downloadHeadRequest){const r=await fetch(s,{method:"HEAD"});if(!r.ok)throw new Error(`The HEAD request failed. code = ${r.status}, message = ${r.statusText}`)}else{console.warn(`DX5: ${t} single-downloading without the HEAD request.`)}this.downloadURL(s,t)}catch(t){e.onError("ESVG-00020",["Type: Single Download",`Target: ${s}`,t.message])}}download(){this.downloadResource()}}class MultiDownTransfer extends CommonTransfer{constructor(t,e,s={}){super();this.status=new DX5DownloadStatus;this.downQueue=e;this.customHeaders=s;this.licenseKey=t.licenseKey;this.credential=t.credential;this.downObjects=t.downObjects;this.downloadChunkedBlock=t.downloadChunkedBlock;this.resumingDownload=t.resumingDownload;this.downloadTimeInterval=t.downloadTimeInterval;this.downloadHeadRequest=t.downloadHeadRequest;this.onerror=t.onDownError.bind(t);this.onbegin=t.onbeginDownload.bind(t);this.onprogress=t.onprogressDownload.bind(t);this.oncomplete=t.oncompleteDownload.bind(t);this.onitemstart=t.onstartDownloadItem.bind(t);this.onitemend=t.onendDownloadItem.bind(t);this.onabort=t.onabortDownload.bind(t);this.oncancel=t.oncancelDownload.bind(t);this.abortion=null}onError(t,e=[]){this.state=this.JOB_STATE_ERROR;this.onerror&&typeof this.onerror==="function"&&this.onerror(t,e)}onBegin(t){this.state=this.JOB_STATE_PROCESSING;this.onbegin&&typeof this.onbegin==="function"&&this.onbegin(t)}onItemStart(t){this.onitemstart&&typeof this.onitemstart==="function"&&this.onitemstart(t)}onProgress(t){this.onprogress&&typeof this.onprogress==="function"&&this.onprogress(t)}onItemEnd(t){this.onitemend&&typeof this.onitemend==="function"&&this.onitemend(t)}onComplete(){this.state=this.JOB_STATE_DONE;this.oncomplete&&typeof this.oncomplete==="function"&&this.oncomplete()}onAbort(){this.state=this.JOB_STATE_ABORT;this.onabort&&typeof this.onabort==="function"&&this.onabort()}onCancel(){this.state=this.JOB_STATE_CANCEL;this.oncancel&&typeof this.oncancel=="function"&&this.oncancel()}parseHeaderStringToMap(t){let e=t.trim().split(/[\r\n]+/);return e.reduce((t,e)=>{const s=e.split(": ");const r=s.shift();const i=s.join(": ");t.set(r.toLocaleLowerCase(),i);return t},new Map)}$resetAbortion(){if(this.abortion&&this.abortion.signal.aborted===false)return;else this.abortion=new AbortController}async downloadOneByOne(t){const i=this;const n=this.status;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&n.isNotCurrentFinished()){}else{const e=this.downQueue.shift();if(this.authenticate(this.licenseKey,e.downUrl)!=true)return;n.readyItem(e,this.downloadChunkedBlock);if(this.downloadHeadRequest){const s=await fetch(n.url,{method:"HEAD",signal:this.abortion.signal,credentials:this.credential?"include":"same-origin"});if(!s.ok){console.info(`DX5: ${n.currentName} HEAD request failed. code = ${s.status}, message = ${s.statusText}`)}else{s.headers.forEach((t,e)=>{if(e==="accept-ranges"){console.info(`DX5: ${n.currentName} Accept-Ranges Header = ${t}`);n.availableRange=t==="bytes"?1:0}else if(e==="content-length"){const s=parseInt(t,10);if(!isNaN(s)&&isFinite(s)){if(s!=n.currentSize){console.warn(`DX5: ${n.currentName} length[${n.currentSize}] does not equal the Content-Length[${t}] of the response.`);n.changeItemSize(s)}}}else if(e==="content-transfer-encoding"){console.warn(`DX5: ${n.currentName} Content-Length: ${t}, Content-Transfer-Encoding: ${t}`);n.availableRange=0}});if(this.resumingDownload===false)n.availableRange=0}}else{n.availableRange=0;console.info(`DX5: ${n.currentName} multi-downloading without the HEAD request.`)}}do{if(n.abortFlag)return this.onAbort();if(n.cancelFlag)return this.onCancel();await new Promise((s,r)=>{const t=n.calculateNextRange();n.xhr=ajax(n.url,n.availableRange===1?"range":"get",{start:t=>n.index===1&&i.onItemStart(n),progress:t=>{n.updateProgress(t.loaded);i.onProgress(n)},load:(t,e)=>{n.updateProgress(t.loaded);n.accumulateData(e);i.onProgress(n);s()},abort:t=>r(new AbortError(`${n.currentName} downloading aborted.`)),timeout:t=>r(new Error(`${n.currentName} downloading timeouted.`)),error:(t,e)=>r(new Error(`${n.currentName} downloading error occured.\nStatus/Code: ${t}\n${e}`))},{ret:"blob",headers:this.customHeaders,credential:this.credential,async:true,startRange:t[0],endRange:t[1]})})}while(n.index<n.pieces);console.info(`DX5: ${n.currentName}(${n.acc.type}, ${n.acc.size}, ${n.pieces}ps) file downloading done.`);if(n.currentSize>0&&n.acc.size!==n.currentSize){console.warn(`DX5: ${n.currentName} file combined size(${n.acc.size}) is different from specified size(${n.currentSize}).`)}this.saveData(n.acc,n.currentItem.name,n.acc.type,this.downObjects.iframe,t=>{n.wrapupCurrent();i.onItemEnd(n);if(i.downQueue.length==0)i.onComplete();setTimeout(t=>i.downloadOneByOne(),i.downloadTimeInterval)},(t,e)=>i.onError(t,e))}catch(t){if(t.name==="AbortError"&&n.abortFlag)this.onAbort();else if(t.name==="AbortError"&&n.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: Multi Download",`Target: ${n.url}`,t.message])}}download(){if(this.state!==this.JOB_STATE_READY)return;const t=this.status;t.reset(this.downQueue.getTotalSize(),this.downQueue.length);this.onBegin(t);this.$resetAbortion();this.downloadOneByOne(false)}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.cancelFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort();this.abortion?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}pause(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_ABORT)return;if(this.state===this.JOB_STATE_ERROR)return;if(this.state===this.JOB_STATE_READY||this.state===this.JOB_STATE_PROCESSING){try{const t=this.status;t.abortFlag=true;this.state=this.JOB_STATE_PENDING;t.xhr?.abort();this.abortion?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}resume(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return;if(this.state===this.JOB_STATE_PROCESSING)return;if(this.state===this.JOB_STATE_ABORT||this.state===this.JOB_STATE_ERROR){try{const t=this.status;t.abortFlag=false;this.state=this.JOB_STATE_PROCESSING;this.$resetAbortion();this.downloadOneByOne(true)}catch(t){this.onError("ESVG-00025",[t.message])}}}}class ExecutionTransfer extends CommonTransfer{constructor(){super()}execute(t){const e=window.open(t.openUrl,"DEXTUploadX5-"+t.id,"memubar=no,toolbar=no,location=no,resizable");if(location.href.indexOf("localhost")<0)e.focus()}}class CompressionTransfer extends SingleDownTransfer{constructor(t,e={}){super(t,e);this.compressXHR=null;this.compressURL=t.compressURL;this.onbegin=t.onbeginCompress.bind(t);this.oncomplete=t.oncompleteCompress.bind(t);this.oncancel=t.oncancelCompress.bind(t)}onError(t,e=[]){this.state=this.JOB_STATE_ERROR;this.onerror&&typeof this.onerror==="function"&&this.onerror(t,e)}onBegin(){this.state=this.JOB_STATE_PROCESSING;this.onbegin&&typeof this.onbegin==="function"&&this.onbegin()}onComplete(){this.state=this.JOB_STATE_DONE;this.oncomplete&&typeof this.oncomplete==="function"&&this.oncomplete()}onCancel(){this.state=this.JOB_STATE_CANCEL;this.oncancel&&typeof this.oncancel=="function"&&this.oncancel()}download(t){if(this.state!==this.JOB_STATE_READY)return;try{const s=this;this.compressXHR=ajax(this.compressURL,"post",{start:t=>s.onBegin(),load:(t,e)=>{console.info(`DX5: The compressed file url: ${e}`);s.onComplete();s.downloadURL(e);this.state=this.JOB_STATE_DONE},abort:t=>s.onCancel(),timeout:t=>s.onError("ESVG-00078",["Type: Compress",`Target: ${s.compressURL}`]),error:(t,e)=>s.onError("ESVG-00076",["Type: Compress",`Target: ${s.compressURL}`,`Status/Code: ${t}`,e])},{res:"text",data:{DEXTUploadX5_VIndexes:t},headers:this.customHeaders,credential:this.credential,async:true})}catch(t){this.onError("ESVG-00075",["Type: Compress",`Target: ${this.compressURL}`,t.message])}}stop(){if(this.state===this.JOB_STATE_DONE)return;if(this.state===this.JOB_STATE_CANCEL)return;if(this.state===this.JOB_STATE_PENDING)return;if(this.state===this.JOB_STATE_READY)return this.onCancel();if(this.state===this.JOB_STATE_ABORT)return this.onCancel();if(this.state===this.JOB_STATE_ERROR)return this.onCancel();if(this.state===this.JOB_STATE_PROCESSING){try{this.state=this.JOB_STATE_PENDING;this.compressXHR?.abort()}catch(t){this.onError("ESVG-00025",[t.message])}}}}class AWSS3SingleDownTransfer extends SingleDownTransfer{constructor(t,e){super(t,e);const s=t.awsS3Configuration.download;this.AWS_SDK_URL=s.sdkURL?s.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.awsS3Config=Object.assign({type:"SECRET",signedURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",makeKey:t=>decodeURIComponent(t.url.split("amazonaws.com/")[1]?.replace(/\+/g," "))},s)}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK."));document.documentElement.appendChild(s)}})}async $downloadNonSecret(){const e=this;const{name:s,url:r}=this.downItem;const t=new window.AWS.S3;if(!r)return this.onError("ESVG-00040");if(this.authenticate(this.licenseKey,r)!=true)return;try{t.getObject({Bucket:this.awsS3Config.bucket,Key:this.awsS3Config.makeKey(this.downItem)},(t,e)=>{if(t)throw t;this.saveData(e.Body,s,e.ContentType,this.downObjects.iframe)})}catch(t){e.onError("ESVG-00020",["Type: AWSS3 NON-SECRET Single download",`Target: ${r}`,t.message])}}async $downloadSecret(){const e=this;const{name:t,url:s}=this.downItem;if(!s)return this.onError("ESVG-00040");if(this.authenticate(this.licenseKey,s)!=true)return;try{const r=new URLSearchParams;r.append("key",e.awsS3Config.makeKey(this.downItem));const i=await fetch(e.awsS3Config.signedURL,{method:"POST",body:r.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"}});if(!i.ok)throw new Error(`The operation to create a pre-signed url for the GET request failed. code = ${i.status}, message = ${i.statusText}`);const n=await i.json();this.downloadURL(n.url,t)}catch(t){e.onError("ESVG-00020",["Type: AWSS3 SECRET Single Download",`Target: ${s}`,t.message])}}async download(){const t=this.awsS3Config;try{if(t.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:t.accessKeyId,secretAccessKey:t.secretAccessKey,region:t.region})}}catch(t){return this.onError("ESVG-00104")}if(t.type==="NON-SECRET")this.$downloadNonSecret();else this.$downloadSecret()}}class AWSS3MultiDownTransfer extends MultiDownTransfer{constructor(t,e,s={}){super(t,e,s);const r=t.awsS3Configuration.download;this.AWS_SDK_URL=r.sdkURL?r.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.awsS3Config=Object.assign({type:"SECRET",signedURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",chunkSize:10*1024*1024,makeKey:t=>decodeURIComponent(t.url.split("amazonaws.com/")[1]?.replace(/\+/g," "))},r)}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK."));document.documentElement.appendChild(s)}})}async $downloadNonSecretOneByOne(t){const s=this;const e=this.status;const r=new window.AWS.S3;const i=this.awsS3Config;const n=i.chunkSize;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&this.status.isNotCurrentFinished()){}else{const o=this.downQueue.shift();if(this.authenticate(this.licenseKey,o.downUrl)!=true)return;e.readyItem(o,n);e.availableRange=this.resumingDownload===true?1:0}do{if(e.abortFlag)return this.onAbort();if(e.cancelFlag)return this.onCancel();const a=e.calculateNextRange();e.index===0&&s.onItemStart(e);const h=e.availableRange===1?await r.getObject({Bucket:i.bucket,Key:i.makeKey(e.currentItem),Range:`bytes=${a[0]}-${a[1]}`}).promise():await r.getObject({Bucket:i.bucket,Key:i.makeKey(e.currentItem)}).promise();e.updateProgress(h.Body.length);e.accumulateData(new Blob([h.Body],{type:h.ContentType}));s.onProgress(e)}while(e.index<e.pieces);console.info(`DX5: ${e.currentName}(${e.acc.type}, ${e.acc.size}, ${e.pieces}ps) file downloading done.`);if(e.currentSize>0&&e.acc.size!==e.currentSize){console.warn(`DX5: ${e.currentName} file combined size(${e.acc.size}) is different from specified size(${e.currentSize}).`)}this.saveData(e.acc,e.currentItem.name,e.acc.type,this.downObjects.iframe,t=>{e.wrapupCurrent();s.onItemEnd(e);if(s.downQueue.length==0)s.onComplete();setTimeout(t=>s.$downloadNonSecretOneByOne(),s.downloadTimeInterval)},(t,e)=>s.onError(t,e))}catch(t){if(t.name==="AbortError"&&e.abortFlag)this.onAbort();else if(t.name==="AbortError"&&e.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: Multi",`Target: ${e.url}`,t.message])}}async $downloadSecretOneByOne(t){const i=this;const n=this.status;const e=this.awsS3Config;const s=e.chunkSize;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&this.status.isNotCurrentFinished()){}else{const r=this.downQueue.shift();if(this.authenticate(this.licenseKey,r.downUrl)!=true)return;n.readyItem(r,s);n.availableRange=this.resumingDownload===true?1:0}do{if(n.abortFlag)return this.onAbort();if(n.cancelFlag)return this.onCancel();const o=new URLSearchParams;o.append("key",e.makeKey(n.currentItem));const a=await fetch(e.signedURL,{method:"POST",body:o.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"},signal:this.abortion.signal,credentials:this.credential?"include":"same-origin"});if(!a.ok)throw new Error(`GET-PRESIGNED-URL: ${e.signedURL}\nStatus/Code: ${a.status}\n${a.statusText}`);const h=await a.json();await new Promise((s,r)=>{const t=n.calculateNextRange();n.xhr=ajax(h.url,n.availableRange===1?"range":"get",{start:t=>n.index===0&&i.onItemStart(n),progress:t=>{n.updateProgress(t.loaded);i.onProgress(n)},load:(t,e)=>{n.updateProgress(t.loaded);n.accumulateData(e);i.onProgress(n);s()},abort:t=>r(new AbortError(`${n.currentName} downloading aborted.`)),timeout:t=>r(new Error(`${n.currentName} downloading timeouted.`)),error:(t,e)=>r(new Error(`${n.currentName} downloading error occured.\nStatus/Code: ${t}\n${e}`))},{ret:"blob",headers:this.customHeaders,credential:this.credential,async:true,startRange:t[0],endRange:t[1]})})}while(n.index<n.pieces);console.info(`DX5: ${n.currentName}(${n.acc.type}, ${n.acc.size}, ${n.pieces}ps) file downloading done.`);if(n.currentSize>0&&n.acc.size!==n.currentSize){console.warn(`DX5: ${n.currentName} file combined size(${n.acc.size}) is different from specified size(${n.currentSize}).`)}this.saveData(n.acc,n.currentItem.name,n.acc.type,this.downObjects.iframe,t=>{n.wrapupCurrent();i.onItemEnd(n);if(i.downQueue.length==0)i.onComplete();setTimeout(t=>i.$downloadSecretOneByOne(),i.downloadTimeInterval)},(t,e)=>i.onError(t,e))}catch(t){if(t.name==="AbortError"&&n.abortFlag)this.onAbort();else if(t.name==="AbortError"&&n.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: Multi",`Target: ${n.url}`,t.message])}}async downloadOneByOne(t){const e=this.awsS3Config;try{if(e.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:e.accessKeyId,secretAccessKey:e.secretAccessKey,region:e.region})}}catch(t){return this.onError("ESVG-00104")}if(e.type==="NON-SECRET")this.$downloadNonSecretOneByOne(t);else this.$downloadSecretOneByOne(t)}}class NCPOSSingleDownTransfer extends SingleDownTransfer{constructor(t,e){super(t,e);const s=t.ncpOSConfiguration.download;const r=this;this.AWS_SDK_URL=s.sdkURL?s.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.ncpOSConfig=Object.assign({type:"SECRET",signedURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",makeKey:t=>decodeURIComponent(r.$transformPathUrlToVirtualHostUrl(t.url).split("object.ncloudstorage.com/")[1]?.replace(/\+/g," "))},s)}$transformPathUrlToVirtualHostUrl(t){const e=new URL(t);const s=e.hostname.split(".");if(s.length===4&&s[1]==="object"&&s[2]==="ncloudstorage"&&s[3]==="com"){const r=s[0];const i=decodeURIComponent(e.pathname.split("/")[1]);const n=decodeURIComponent(e.pathname.split("/").slice(2).join("/"));return`https://${encodeURIComponent(i)}.${r}.object.ncloudstorage.com/${encodeURIComponent(n)}`}else if(s.length===5&&s[2]==="object"&&s[3]==="ncloudstorage"&&s[4]==="com"){return t}else{throw new Error("The URL is not matched with the pattern of the NCP Object Storage URL.")}}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK for NCPOS."));document.documentElement.appendChild(s)}})}async $downloadNonSecret(){const e=this;const{name:s,url:r}=this.downItem;const t=new window.AWS.S3;if(!r)return this.onError("ESVG-00040");try{if(this.authenticate(this.licenseKey,this.$transformPathUrlToVirtualHostUrl(r))!=true)return;t.getObject({Bucket:this.ncpOSConfig.bucket,Key:this.ncpOSConfig.makeKey(this.downItem)},(t,e)=>{if(t)throw t;this.saveData(e.Body,s,e.ContentType,this.downObjects.iframe)})}catch(t){e.onError("ESVG-00020",["Type: NCPOS NON-SECRET Single download",`Target: ${r}`,t.message])}}async $downloadSecret(){const e=this;const{name:t,url:s}=this.downItem;if(!s)return this.onError("ESVG-00040");try{if(this.authenticate(this.licenseKey,this.$transformPathUrlToVirtualHostUrl(s))!=true)return;const r=new URLSearchParams;r.append("key",e.ncpOSConfig.makeKey(this.downItem));const i=await fetch(e.ncpOSConfig.signedURL,{method:"POST",body:r.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"}});if(!i.ok)throw new Error(`The operation to create a pre-signed url for the GET request failed. code = ${i.status}, message = ${i.statusText}`);const n=await i.json();this.downloadURL(n.url,t)}catch(t){e.onError("ESVG-00020",["Type: NCPOS SECRET Single Download",`Target: ${s}`,t.message])}}async download(){const t=this.ncpOSConfig;try{if(t.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:t.accessKeyId,secretAccessKey:t.secretAccessKey,region:t.region,endpoint:`https://${t.region}.object.ncloudstorage.com`,signatureVersion:"v4"})}}catch(t){return this.onError("ESVG-00104")}if(t.type==="NON-SECRET")this.$downloadNonSecret();else this.$downloadSecret()}}class NCPOSMultiDownTransfer extends MultiDownTransfer{constructor(t,e,s={}){super(t,e,s);const r=t.ncpOSConfiguration.download;const i=this;this.AWS_SDK_URL=r.sdkURL?r.sdkURL:"https://sdk.amazonaws.com/js/aws-sdk-2.1037.0.min.js";this.ncpOSConfig=Object.assign({type:"SECRET",signedURL:"",bucket:"",region:"",accessKeyId:"",secretAccessKey:"",chunkSize:10*1024*1024,makeKey:t=>decodeURIComponent(i.$transformPathUrlToVirtualHostUrl(t.url).split("object.ncloudstorage.com/")[1]?.replace(/\+/g," "))},r)}$transformPathUrlToVirtualHostUrl(t){const e=new URL(t);const s=e.hostname.split(".");if(s.length===4&&s[1]==="object"&&s[2]==="ncloudstorage"&&s[3]==="com"){const r=s[0];const i=decodeURIComponent(e.pathname.split("/")[1]);const n=decodeURIComponent(e.pathname.split("/").slice(2).join("/"));return`https://${encodeURIComponent(i)}.${r}.object.ncloudstorage.com/${encodeURIComponent(n)}`}else if(s.length===5&&s[2]==="object"&&s[3]==="ncloudstorage"&&s[4]==="com"){return t}else{throw new Error("The URL is not matched with the pattern of the NCP Object Storage URL.")}}$loadAWSSDK(){return new Promise((t,e)=>{if(window.AWS)t();else{const s=document.createElementNS("http://www.w3.org/2000/svg","script");s.setAttribute("type","application/ecmascript");s.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",this.AWS_SDK_URL);s.onload=t;s.onerror=t=>e(new Error("Failed to load AWS SDK for NCPOS."));document.documentElement.appendChild(s)}})}async $downloadNonSecretOneByOne(t){const s=this;const e=this.status;const r=new window.AWS.S3;const i=this.ncpOSConfig;const n=i.chunkSize;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&this.status.isNotCurrentFinished()){}else{const o=this.downQueue.shift();if(this.authenticate(this.licenseKey,this.$transformPathUrlToVirtualHostUrl(o.downUrl))!=true)return;e.readyItem(o,n);e.availableRange=this.resumingDownload===true?1:0}do{if(e.abortFlag)return this.onAbort();if(e.cancelFlag)return this.onCancel();const a=e.calculateNextRange();e.index===0&&s.onItemStart(e);const h=e.availableRange===1?await r.getObject({Bucket:i.bucket,Key:i.makeKey(e.currentItem),Range:`bytes=${a[0]}-${a[1]}`}).promise():await r.getObject({Bucket:i.bucket,Key:i.makeKey(e.currentItem)}).promise();e.updateProgress(h.Body.length);e.accumulateData(new Blob([h.Body],{type:h.ContentType}));s.onProgress(e)}while(e.index<e.pieces);console.info(`DX5: ${e.currentName}(${e.acc.type}, ${e.acc.size}, ${e.pieces}ps) file downloading done.`);if(e.currentSize>0&&e.acc.size!==e.currentSize){console.warn(`DX5: ${e.currentName} file combined size(${e.acc.size}) is different from specified size(${e.currentSize}).`)}this.saveData(e.acc,e.currentItem.name,e.acc.type,this.downObjects.iframe,t=>{e.wrapupCurrent();s.onItemEnd(e);if(s.downQueue.length==0)s.onComplete();setTimeout(t=>s.$downloadNonSecretOneByOne(),s.downloadTimeInterval)},(t,e)=>s.onError(t,e))}catch(t){if(t.name==="AbortError"&&e.abortFlag)this.onAbort();else if(t.name==="AbortError"&&e.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: NCPOS Multi",`Target: ${e.url}`,t.message])}}async $downloadSecretOneByOne(t){const i=this;const n=this.status;const e=this.ncpOSConfig;const s=e.chunkSize;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&this.status.isNotCurrentFinished()){}else{const r=this.downQueue.shift();if(this.authenticate(this.licenseKey,this.$transformPathUrlToVirtualHostUrl(r.downUrl))!=true)return;n.readyItem(r,s);n.availableRange=this.resumingDownload===true&&n.currentItem.size>0?1:0}do{if(n.abortFlag)return this.onAbort();if(n.cancelFlag)return this.onCancel();const o=new URLSearchParams;o.append("key",e.makeKey(n.currentItem));const a=await fetch(e.signedURL,{method:"POST",body:o.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"},signal:this.abortion.signal,credentials:this.credential?"include":"same-origin"});if(!a.ok)throw new Error(`GET-PRESIGNED-URL: ${e.signedURL}\nStatus/Code: ${a.status}\n${a.statusText}`);const h=await a.json();await new Promise((s,r)=>{const t=n.calculateNextRange();n.xhr=ajax(h.url,n.availableRange===1?"range":"get",{start:t=>n.index===0&&i.onItemStart(n),progress:t=>{n.updateProgress(t.loaded);i.onProgress(n)},load:(t,e)=>{n.updateProgress(t.loaded);n.accumulateData(e);i.onProgress(n);s()},abort:t=>r(new AbortError(`${n.currentName} downloading aborted.`)),timeout:t=>r(new Error(`${n.currentName} downloading timeouted.`)),error:(t,e)=>r(new Error(`${n.currentName} downloading error occured.\nStatus/Code: ${t}\n${e}`))},{ret:"blob",headers:this.customHeaders,credential:this.credential,async:true,startRange:t[0],endRange:t[1]})})}while(n.index<n.pieces);console.info(`DX5: ${n.currentName}(${n.acc.type}, ${n.acc.size}, ${n.pieces}ps) file downloading done.`);if(n.currentSize>0&&n.acc.size!==n.currentSize){console.warn(`DX5: ${n.currentName} file combined size(${n.acc.size}) is different from specified size(${n.currentSize}).`)}this.saveData(n.acc,n.currentItem.name,n.acc.type,this.downObjects.iframe,t=>{n.wrapupCurrent();i.onItemEnd(n);if(i.downQueue.length==0)i.onComplete();setTimeout(t=>i.$downloadSecretOneByOne(),i.downloadTimeInterval)},(t,e)=>i.onError(t,e))}catch(t){if(t.name==="AbortError"&&n.abortFlag)this.onAbort();else if(t.name==="AbortError"&&n.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: NCPOS Multi",`Target: ${n.url}`,t.message])}}async downloadOneByOne(t){const e=this.ncpOSConfig;try{if(e.type==="NON-SECRET"){await this.$loadAWSSDK();window.AWS.config.update({accessKeyId:e.accessKeyId,secretAccessKey:e.secretAccessKey,region:e.region,endpoint:`https://${e.region}.object.ncloudstorage.com`,signatureVersion:"v4"})}}catch(t){return this.onError("ESVG-00104")}if(e.type==="NON-SECRET")this.$downloadNonSecretOneByOne(t);else this.$downloadSecretOneByOne(t)}}class AzureBlobSingleDownTransfer extends SingleDownTransfer{constructor(t,e){super(t,e);const s=t.azrbsConfiguration.download;const r=this;this.azrbsConfig=Object.assign({accountName:"",containerName:"",sasDownloadURL:"",makeKey:t=>decodeURIComponent(r.$extractBlobPath(t.url).replace(/\+/g," "))},s)}$extractBlobPath(t){const e=new URL(t);const s=e.pathname.split("/");if(s.length>=3&&s[1]===this.azrbsConfig.containerName){return s[2]}else{throw new Error("The URL is not matched with the pattern of the Azure Blob Storage URL.")}}async $getSasToken(t){const e=this.azrbsConfig;const s=new URLSearchParams;s.append("key",t);const r=await fetch(e.sasDownloadURL,{method:"POST",body:s.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"},credentials:this.credential?"include":"same-origin"});if(r.ok){return await r.text()}else{const i=await r.text();throw new Error(`GET-SASTOKEN-URL: ${e.sasTokenURL}\nStatus/Code: ${r.status.toString()}\n${i}`)}}async download(){const e=this;const t=this.azrbsConfig;const s=this.downItem;const{name:r,url:i}=s;if(!i)return this.onError("ESVG-00040");try{const n=t.makeKey(s);const o=`https://${t.accountName}.blob.core.windows.net/${t.containerName}/${encodeURIComponent(n)}`;if(this.authenticate(this.licenseKey,o)!=true)return;const a=await this.$getSasToken(n);const h=`${o}?${a}`;this.downloadURL(h,r)}catch(t){e.onError("ESVG-00020",["Type: AZRBS Single",`Target: ${i}`,t.message])}}}class AzureBlobMultiDownTransfer extends MultiDownTransfer{constructor(t,e,s={}){super(t,e,s);const r=t.azrbsConfiguration.download;const i=this;this.azrbsConfig=Object.assign({accountName:"",containerName:"",sasDownloadURL:"",blockSize:10*1024*1024,makeKey:t=>decodeURIComponent(i.$extractBlobPath(t.url).replace(/\+/g," "))},r)}$extractBlobPath(t){const e=new URL(t);const s=e.pathname.split("/");if(s.length>=3&&s[1]===this.azrbsConfig.containerName){return s[2]}else{throw new Error("The URL is not matched with the pattern of the Azure Blob Storage URL.")}}async $getSasToken(t){const e=this.azrbsConfig;const s=new URLSearchParams;s.append("key",t);const r=await fetch(e.sasDownloadURL,{method:"POST",body:s.toString(),headers:{"Content-Type":"application/x-www-form-urlencoded"},signal:this.abortion.signal,credentials:this.credential?"include":"same-origin"});if(r.ok){return await r.text()}else{const i=await r.text();throw new Error(`GET-SASTOKEN-URL: ${e.sasTokenURL}\nStatus/Code: ${r.status.toString()}\n${i}`)}}async downloadOneByOne(t){const i=this;const e=this.azrbsConfig;const n=this.status;const s=e.blockSize;if(this.state===this.JOB_STATE_DONE)return;try{if(t===true&&n.isNotCurrentFinished()){}else{const a=this.downQueue.shift();n.readyItem(a,s);n.availableRange=this.resumingDownload===true&&n.currentItem.size>0?1:0}const r=e.makeKey(n.currentItem);const o=`https://${e.accountName}.blob.core.windows.net/${e.containerName}/${encodeURIComponent(r)}`;if(this.authenticate(this.licenseKey,o)!=true)return;do{if(n.abortFlag)return this.onAbort();if(n.cancelFlag)return this.onCancel();const h=await this.$getSasToken(r);const l=`${o}?${h}`;await new Promise((s,r)=>{const t=n.calculateNextRange();n.xhr=ajax(l,n.availableRange===1?"range":"get",{start:t=>n.index===0&&i.onItemStart(n),header:t=>{const e=t.getResponseHeader("Content-Length");if(e){const s=parseInt(e,10);if(!isNaN(s)&&n.currentSize!==s){console.warn(`DX5: ${n.currentName} length[${n.currentSize}] does not equal the Content-Length[${s}] of the response.`);n.changeItemSize(s)}}},progress:t=>{n.updateProgress(t.loaded);i.onProgress(n)},load:(t,e)=>{n.updateProgress(t.loaded);n.accumulateData(e);i.onProgress(n);s()},abort:t=>r(new AbortError(`${n.currentName} downloading aborted.`)),timeout:t=>r(new Error(`${n.currentName} downloading timeouted.`)),error:(t,e)=>r(new Error(`${n.currentName} downloading error occured.\nStatus/Code: ${t}\n${e}`))},{ret:"blob",headers:this.customHeaders,credential:this.credential,async:true,startRange:t[0],endRange:t[1]})})}while(n.index<n.pieces);console.info(`DX5: ${n.currentName}(${n.acc.type}, ${n.acc.size}, ${n.pieces}ps) file downloading done.`);if(n.currentSize>0&&n.acc.size!==n.currentSize){console.warn(`DX5: ${n.currentName} file combined size(${n.acc.size}) is different from specified size(${n.currentSize}).`)}this.saveData(n.acc,n.currentItem.name,n.acc.type,this.downObjects.iframe,t=>{n.wrapupCurrent();i.onItemEnd(n);if(i.downQueue.length==0)i.onComplete();setTimeout(t=>i.downloadOneByOne(),i.downloadTimeInterval)},(t,e)=>i.onError(t,e))}catch(t){if(t.name==="AbortError"&&n.abortFlag)this.onAbort();else if(t.name==="AbortError"&&n.cancelFlag)this.onCancel();else this.onError("ESVG-00020",["Type: AZRBS Multi",`Target: ${n.url}`,t.message])}}}class DX5FileEngine{constructor(t,e,s){this.REQUEST_MEHTOD_UPLOAD="POST";this.controlId=t;this.environment=e;this.fileManager=s;this.licenseKey="";this.uploadUrl="";this.compressURL="";this.result=[];this.isPHP=false;this.uploadMode="ORAF";this.chunkedBlock=10*1024*1024;this.splitString="[SPLT]";this.emptyString="[EMPTY]";this.fileManager=s;this.compressXHR=null;this.limitMDSize=1024*1024*100;this.customHeaders={};this.credential=false;this.downObjects=null;this.useChecksum=false;this.checksumWorker=null;this.downloadChunkedBlock=10*1024*1024;this.resumingUpload=true;this.resumingDownload=true;this.uploadTimeInterval=200;this.downloadTimeInterval=200;this.downloadHeadRequest=true;this.currentJob=null;this.awsS3Configuration={upload:null,download:null};this.ncpOSConfiguration={upload:null,download:null};this.azrbsConfiguration={upload:null,download:null};this.downloadMode="DEFAULT";this.stateUpload={totalSize:0,totalCount:0,totalSendSize:0,completeCount:0,currentName:"",currentSize:0,currentSendSize:0,totalRate:0,totalSpeed:0,currentRate:0,currentSpeed:0,totalTime:null,currentTime:null,remainedTotalTime:null,remainedCurrentTime:null,currentHashingRate:0};this.stateDownload={totalSize:0,totalCount:0,totalReceiveSize:0,completeCount:0,currentName:"",currentSize:0,currentReceiveSize:0,totalRate:0,totalSpeed:0,currentRate:0,currentSpeed:0,totalTime:null,currentTime:null,remainedTotalTime:null,remainedCurrentTime:null}}onUpError(t,e){outError(t,e)}onDownError(t,e){downloadErrorOut(t,e)}onbeginUpload(t){const e=this;this.onprogressUpload(t);setTimeout(t=>dispatchDEXTX5Event("uploadBegin",createDEXTX5Event("uploadBegin",{id:e.controlId})),1)}onprogressUpload(t){if(!t)return;this.stateUpload.totalSize=t.progress.totalSize;this.stateUpload.totalSendSize=t.progress.totalSendSize;this.stateUpload.totalCount=t.progress.totalCount;this.stateUpload.completeCount=t.progress.completeCount;this.stateUpload.currentSize=t.progress.currentSize;this.stateUpload.currentSendSize=t.progress.currentSendSize;this.stateUpload.currentName=t.progress.currentName;this.stateUpload.totalRate=parseFloat((t.progress.getTotalRate()*100).toFixed(1));this.stateUpload.totalSpeed=parseFloat(t.progress.getTotalSpeed().toFixed(1));this.stateUpload.currentRate=parseFloat((t.progress.getCurrentRate()*100).toFixed(1));this.stateUpload.currentSpeed=parseFloat(t.progress.getCurrentSpeed().toFixed(1));this.stateUpload.totalTime=t.progress.getTotalSendTime();this.stateUpload.currentTime=t.progress.getCurrentSendTime();this.stateUpload.remainedTotalTime=t.progress.getRemainedTotalTime();this.stateUpload.remainedCurrentTime=t.progress.getRemainedCurrentTime();this.stateUpload.currentHashingRate=parseFloat((t.progress.getCurrentHashingRate()*100).toFixed(1))}oncompleteUpload(e){const s=this;setTimeout(t=>dispatchDEXTX5Event("uploadCompleted",createDEXTX5Event("uploadCompleted",{id:s.controlId,result:e})),1)}onstartUploadItem(e){const s=this;this.onprogressUpload(e);setTimeout(t=>dispatchDEXTX5Event("uploadItemStart",createDEXTX5Event("uploadItemStart",{id:s.controlId,itemId:e.currentItem?e.currentItem.id:null})),1)}onendUploadItem(e,s){const r=this;this.onprogressUpload(e);setTimeout(t=>dispatchDEXTX5Event("uploadItemEnd",createDEXTX5Event("uploadItemEnd",{id:r.controlId,itemId:e.currentItem?e.currentItem.id:null,response:s})),1)}onabortUpload(){const e=this;setTimeout(t=>dispatchDEXTX5Event("uploadAborted",createDEXTX5Event("uploadAborted",{id:e.controlId})),1)}oncancelUpload(){const e=this;setTimeout(t=>dispatchDEXTX5Event("uploadStopped",createDEXTX5Event("uploadStopped",{id:e.controlId})),1)}onbeginDownload(t){const e=this;this.onprogressDownload(t);setTimeout(t=>dispatchDEXTX5Event("downloadBegin",createDEXTX5Event("downloadBegin",{id:e.controlId})),1)}onprogressDownload(t){if(!t)return;this.stateDownload.totalSize=t.totalSize;this.stateDownload.totalReceiveSize=t.totalSendSize;this.stateDownload.totalCount=t.totalCount;this.stateDownload.completeCount=t.completeCount;this.stateDownload.currentSize=t.currentSize;this.stateDownload.currentReceiveSize=t.currentSendSize;this.stateDownload.currentName=t.currentName;this.stateDownload.totalRate=parseFloat((t.getTotalRate()*100).toFixed(1));this.stateDownload.totalSpeed=parseFloat(t.getTotalSpeed().toFixed(1));this.stateDownload.currentRate=parseFloat((t.getCurrentRate()*100).toFixed(1));this.stateDownload.currentSpeed=parseFloat(t.getCurrentSpeed().toFixed(1));this.stateDownload.totalTime=t.getTotalSendTime();this.stateDownload.currentTime=t.getCurrentSendTime();this.stateDownload.remainedTotalTime=t.getRemainedTotalTime();this.stateDownload.remainedCurrentTime=t.getRemainedCurrentTime()}oncompleteDownload(){const e=this;setTimeout(t=>dispatchDEXTX5Event("downloadCompleted",createDEXTX5Event("downloadCompleted",{id:e.controlId})),1)}onstartDownloadItem(e){const s=this;this.onprogressDownload(e);setTimeout(t=>dispatchDEXTX5Event("downloadItemStart",createDEXTX5Event("downloadItemStart",{id:s.controlId,itemId:e.currentItem?e.currentItem.id:null})),1)}onendDownloadItem(e){const s=this;this.onprogressDownload(e);setTimeout(t=>dispatchDEXTX5Event("downloadItemEnd",createDEXTX5Event("downloadItemEnd",{id:s.controlId,itemId:e.currentItem?e.currentItem.id:null})),1)}oncancelDownload(){const e=this;setTimeout(t=>dispatchDEXTX5Event("downloadStopped",createDEXTX5Event("downloadStopped",{id:e.controlId})),1)}onabortDownload(){const e=this;setTimeout(t=>dispatchDEXTX5Event("downloadAborted",createDEXTX5Event("downloadAborted",{id:e.controlId})),1)}onbeginCompress(){const e=this;setTimeout(t=>dispatchDEXTX5Event("compressBegin",createDEXTX5Event("compressBegin",{id:e.controlId})),1)}oncompleteCompress(){const e=this;setTimeout(t=>dispatchDEXTX5Event("compressCompleted",createDEXTX5Event("compressCompleted",{id:e.controlId})),1)}oncancelCompress(){const e=this;setTimeout(t=>dispatchDEXTX5Event("compressStopped",createDEXTX5Event("compressStopped",{id:e.controlId})),1)}acting(){return this.currentJob&&(this.currentJob.state===this.currentJob.JOB_STATE_PROCESSING||this.currentJob.state===this.currentJob.JOB_STATE_PENDING)?true:false}upload(r){if(this.acting())return this.onUpError("ESVG-00024");if(!this.licenseKey)return this.onUpError("ESVG-00035");if(["AWSS3","NCPOS","AZRBS"].includes(this.uploadMode)===false&&!this.uploadUrl)return this.onUpError("ESVG-00053");if(this.uploadMode==="AWSS3"&&!this.awsS3Configuration.upload)return this.onUpError("ESVG-00100");if(this.uploadMode==="NCPOS"&&!this.ncpOSConfiguration.upload)return this.onUpError("ESVG-00109");if(this.uploadMode==="AZRBS"&&!this.azrbsConfiguration.upload)return this.onUpError("ESVG-00117");const i=new DX5FileList;for(let t=0,e=r.length,s=null;t<e;t++){s=this.fileManager.ufiles.getItem(r[t]);if(s&&s.status=="WAIT"&&s.type=="FILE"){i.push(s)}}if(i.length==0)return this.onUpError("ESVG-00043");if(this.currentJob&&this.currentJob.isDoneResponse==false){}else{this.result=[]}switch(this.uploadMode){case"ORAF":this.currentJob=new ORAFTransfer(this,this.result,i,this.customHeaders);break;case"OROF":this.currentJob=new OROFTransfer(this,this.result,i,this.customHeaders);break;case"EXNJ":case"EXTS":this.currentJob=new ExtensionTransfer(this,this.result,i,this.customHeaders);break;case"AWSS3":this.currentJob=new AWSS3UploadTransfer(this,this.result,i);break;case"NCPOS":this.currentJob=new NCPOSUploadTransfer(this,this.result,i);break;case"AZRBS":this.currentJob=new AzureBlobUploadTransfer(this,this.result,i);break}this.currentJob.upload()}stopUploading(t){this.currentJob?.stop();t&&typeof t==="function"&&t()}pauseUploading(t){this.currentJob?.pause();t&&typeof t==="function"&&t()}resumeUploading(t){this.currentJob?.resume();t&&typeof t==="function"&&t()}download(t,e){if(this.acting())return this.onDownError("ESVG-00024");if(!this.licenseKey)return this.onDownError("ESVG-00035");if(this.downloadMode==="AWSS3"&&!this.awsS3Configuration.download)return this.onUpError("ESVG-00100");if(this.downloadMode==="NCPOS"&&!this.ncpOSConfiguration.download)return this.onUpError("ESVG-00109");if(this.downloadMode==="AZRBS"&&!this.azrbsConfiguration.download)return this.onUpError("ESVG-00117");const s=new DX5FileList;for(var r=0,i=t.length,n=null;r<i;r++){n=this.fileManager.ufiles.getItem(t[r]);if(this.limitMDSize>=0&&n.size>this.limitMDSize){return this.onDownError("ESVG-00065",[this.limitMDSize])}else{s.push(n)}}if(s.length==0)return this.onDownError("ESVG-00022");if(e){if(this.downloadMode==="AWSS3")this.currentJob=new AWSS3MultiDownTransfer(this,s,this.customHeaders);else if(this.downloadMode==="NCPOS")this.currentJob=new NCPOSMultiDownTransfer(this,s,this.customHeaders);else if(this.downloadMode==="AZRBS")this.currentJob=new AzureBlobMultiDownTransfer(this,s,this.customHeaders);else this.currentJob=new MultiDownTransfer(this,s,this.customHeaders)}else{if(this.downloadMode==="AWSS3")this.currentJob=new AWSS3SingleDownTransfer(this,s[0],this.customHeaders);else if(this.downloadMode==="NCPOS")this.currentJob=new NCPOSSingleDownTransfer(this,s[0],this.customHeaders);else if(this.downloadMode==="AZRBS")this.currentJob=new AzureBlobSingleDownTransfer(this,s[0],this.customHeaders);else this.currentJob=new SingleDownTransfer(this,s[0],this.customHeaders)}this.currentJob.download()}stopDownloading(t){this.currentJob?.stop();t&&typeof t==="function"&&t()}pauseDownloading(t){this.currentJob?.pause();t&&typeof t==="function"&&t()}resumeDownloading(t){this.currentJob?.resume();t&&typeof t==="function"&&t()}stopCompressWaiting(){this.currentJob?.stop()}downloadCompressed(t){if(this.acting())return this.onDownError("ESVG-00024");if(!this.compressURL)return this.onDownError("ESVG-00077");const r=this;const i=[];t.forEach(function(t,e){let s=r.fileManager.ufiles.getItem(t);if(s&&s.vindex){i.push(encodeURIComponent(s.vindex))}});if(i.length==0)return this.onDownError("ESVG-00022");this.currentJob=new CompressionTransfer(this);this.currentJob.download(i)}run(t){if(this.acting())return this.onDownError("ESVG-00024");if(!t)return;const e=this.fileManager.ufiles.getItem(t);if(!e)return this.onDownError("ESVG-00023");this.currentJob=new ExecutionTransfer(this);this.currentJob.execute(e)}}