package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class OROFUpload extends HttpServlet {
	
	private Environment env;
       
    public OROFUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();	
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			dextnj = new FileUpload(request, env);			

			dextnj.prepare();			
			
			FileItem file = dextnj.getFileItem(0);

			if (file.isEmpty() == false) {
				file.save();
				
				response.setCharacterEncoding("UTF-8");
				response.setContentType("text/plain");
				response.getWriter().write(String.format("F:%1$s", file.getFilename()));
			} else {
				response.setCharacterEncoding("UTF-8");
				response.setContentType("text/plain");
				response.getWriter().write(String.format("X:No file"));				
			}			
			
		} catch (Exception e) {
			throw new ServletException(e);
		} finally {
			if (dextnj != null) dextnj.close();
		}
	}
}
