package sample_x5_nj_servlet_en;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@SuppressWarnings("serial")
public class FormService extends HttpServlet {
	
    public FormService() {
        super();
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		request.setCharacterEncoding("UTF-8");
		
		// The DataEntity is a dummy class used for helping to show the result of uploading.
		DataEntity data = new DataEntity();
		
		data.setText1(request.getParameter("text1"));
		data.setRadio1(request.getParameter("radio1"));
		data.setCheckbox1(request.getParameter("checkbox1"));
		data.setCheckbox2(request.getParameter("checkbox2"));
		data.setCheckbox3(request.getParameter("checkbox3"));
		data.setSelect1(request.getParameter("select1"));
		
		List<FileEntity> files = data.getFiles();
		
		String[] tokens = request.getParameter("newFileKeys").split(";");
		for (String key : tokens) {
			if (key.isEmpty() == false) {
				files.add(FileRepository.getFileEntity(key));
			}
		}

		String strDeleteKeys = request.getParameter("deleteFileKeys");
		if (strDeleteKeys != null && strDeleteKeys.length() > 0) {
			data.setDeleteDescription(strDeleteKeys + " deleted.");
		} else {
			data.setDeleteDescription("No deleted files.");
		}
		
		// The DataRepository is a dummy class used for helping to show the result of uploading.
		String key = DataRepository.addDataEntity(data);
		
		if (strDeleteKeys != null) {
			// The process of deleting the physical file uploaded to the real server is safe at the end of every transaction.
		}
		
		String referer = request.getHeader("referer");
		response.sendRedirect(referer.substring(0, referer.lastIndexOf("/")).concat("/view-form.jsp?key=").concat(key));		
	}
}
