package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.FormItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class FolderUpload extends HttpServlet {		
	
	private Environment env;
       
    public FolderUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();		
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			dextnj = new FileUpload(request, env);
	
			dextnj.prepare();
			
			// Get a file collection object.
			List<FileItem> items = dextnj.getFileItems();			
			// Get a collection object with a folder path. items.size() == folders.size()
			List<FormItem> folders = dextnj.getFormItems("DEXTUploadX5_Folder");
			
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			FormItem form = null;
			File dir = null;
			
			for (int i = 0; i < items.size(); i++) {
				file = items.get(i);
				if (file.isEmpty()) continue;
					
				form = folders.get(i);				
				// Get path to be saved including directory(folder) information.
				dir = new File(env.getDefaultRepository(), form.getValue());
				// Create the folder structure.
				if (dir.exists() == false) dir.mkdirs();
				// Save the file to the destination folder.
				file.save(dir.getCanonicalPath());
				sb.append(String.format("F:%1$s\n", file.getLastSavedFilePath()));
			}
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			throw new ServletException(e);
		} finally {
			if (dextnj != null) dextnj.close();
		}
	}
}
