package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.CompressUtil;
import devpia.dextuploadnj.support.common.FileDownload;


@SuppressWarnings("serial")
public class FileCompression extends HttpServlet {

	private String fileRoot;
	
    public FileCompression() {
        super();
    }

    public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		fileRoot = config.getServletContext().getRealPath("/files/");
	}
    
    /**
     * When a GET request is made, download the zipped file.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String compresskey = request.getParameter("compresskey");
		
		FileEntity target = FileRepository.getFileEntity(compresskey);
		if (target != null) {
			FileDownload dextnj = new FileDownload();
			dextnj.setAllowingWeakRange(false);
			dextnj.setRemoveAfterDownloading(true);
			dextnj.download(request, response, target.getFile(), target.getFilename(), null, false, false);
		} else {
			response.sendError(404);
		}		
	}

    /**
     * For POST requests, compress the file and return a downloadable path as response data.
     */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		List<File> files = new ArrayList<File>();
		String vindices = request.getParameter("DEXTUploadX5_VIndexes");
		String[] tokens = vindices.split(",");
		for (int i = 0; i < tokens.length; i++) {
			if (tokens[i].equals("IDX0003"))
				files.add(new File(fileRoot, "attach/bridge_509147.jpg"));
			if (tokens[i].equals("IDX0004"))
				files.add(new File(fileRoot, "attach/beach_239826.jpg"));
			if (tokens[i].equals("IDX0005"))
				files.add(new File(fileRoot, "attach/cosmos (empty) 195779.jpg"));
		}
		
		// Create a compressed file in a temporary location.
		CompressUtil cu = new CompressUtil();
		File zipped = cu.zip(files, new File(fileRoot, "/temp/"), "UTF-8", false, false);
		
		// The FileEntity and FileRepository classes are not included in the DEXTUploadNJ component,
		// They are used to illustrate the process of compressing a file and downloading the compressed file.
		FileEntity target = new FileEntity();
		target.setMime("application/x-zip-compressed");
		target.setFilename(zipped.getName());
		target.setFile(zipped);
		target.setSize(zipped.length());
		
		String compresskey = FileRepository.addFileEntity(target);
		
		response.setContentType("text/plain");		
		response.getWriter().write(request.getRequestURL().append("?compresskey=".concat(compresskey)).toString());
	}

}
