package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class ExtensionUpload extends HttpServlet {
	
    public ExtensionUpload() {
        super();
    }
    
    @Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		String key = "";
		
		try {
			// Create a FileUpload object that takes an HTTP request object. 
			dextnj = new FileUpload(request);
			
			dextnj.prepare();
			
			// You can use the FileUpload#getFileItem method to get the uploaded file information.
			FileItem item = dextnj.getFileItem();
			
			if (!item.isEmpty()) {
				// If there is no directory path given as an argument, the path set by defaultRepository parameter value of extensionUploadFilter filter is targeted. 
				item.save();
				
				FileEntity file = new FileEntity();
				file.setFieldName(item.getFieldName());
				file.setFilename(item.getFilename());
				file.setMime(item.getContentType());
				file.setSize(item.getFileSize());
				file.setFile(new File(item.getLastSavedFilePath()));
				
				key = FileRepository.addFileEntity(file);
			} else {
				// If there is no any file, you must raise an error.
				// If you do not want to handle exceptions, you must send the HTTP status code as an error by using "response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);".
			}
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(key);
			
		} finally {
			// Remove resources.
			// All temporary files that have not been deleted are deleted.
			if (dextnj != null) dextnj.close();
		}
	}
}
