package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.FormItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class EXIFUpload extends HttpServlet {		
	
	private Environment env;
       
    public EXIFUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();		
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			dextnj = new FileUpload(request, env);
	
			dextnj.prepare();
			
			List<FileItem> items = dextnj.getFileItems();
			
			// Use the FileUpload#getFormItems method to get the EXIF ​​collection object passed from the client by form name.
			List<FormItem> exifs = dextnj.getFormItems("DEXTUploadX5_EXIFData");
			
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			FormItem form = null;
			String[] tokens = null;
			StringBuffer exif = new StringBuffer();
			
			for (int i = 0; i < items.size(); i++) {
				file = items.get(i);
				form = exifs.get(i);
				
				if (file.isEmpty() == false) {
					file.save();
					
					tokens = form.getValue().split("\\[SPLT\\]");
					
					exif.delete(0, exif.length());
					for (int k = 0, len = tokens.length; (k + 1) < len; k += 2) {
						exif.append(String.format("%1$s:%2$s\n", tokens[k], tokens[k + 1]));
					}
					
					sb.append(String.format("F:%1$s\n%2$s\n", file.getLastSavedFilename(), exif.toString()));
				}
			}

			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			throw new ServletException(e);
		} finally {
			if (dextnj != null) dextnj.close();
		}
	}
}
