package sample_x5_nj_servlet_en;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class CommonUpload extends HttpServlet {

	private Environment env;
       
    public CommonUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			// Set to the license file path for the DEXTUploadNJ.
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();
		
		// Set the temporary directory path, default directory path and etc.
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			// Create a FileUpload object that takes an HTTP request object and a configuration object as arguments. 
			dextnj = new FileUpload(request, env);
			
			// Store all the file data part from the client as a temporary file.
			// Temporary save location is set by Environment#setTempRepository method. 
			dextnj.prepare();
			
			// You can use the FileUpload#getFileItem method to call by form name, but you can get the collection object using the getFileItems method.
			List<FileItem> items = dextnj.getFileItems();
			
			// A buffer for writing response data.
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			for (int i = 0; i < items.size(); i++) {
				
				file = items.get(i);
				
				if (file.isEmpty() == false) {
					// If the item is the correct file, saves(copy or move) the file from a temporary location to target.
					// If there is no directory path given as an argument, the target will be the path set by the Environment#setDefaultRepository method.
					file.save();
					
					// Writing the location of the saved file to the response data buffer. 
					sb.append(String.format("F:%1$s\n", file.getFilename()));
				}
			}
			
			// Creating response data. 
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			// If there is a problem, you must raise an error.
			// If you do not want to handle exceptions, you must send the HTTP status code as an error by using "response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);".
			throw new ServletException(e);
		} finally {
			// Remove resources.
			// All temporary files that have not been deleted are deleted.
			if (dextnj != null) dextnj.close();
		}
	}
}
