package sample_x5_nj_servlet_ko;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.FormItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class MetaDataUpload extends HttpServlet {		
	
	private Environment env;
       
    public MetaDataUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();		
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			dextnj = new FileUpload(request, env);
	
			dextnj.prepare();
			
			List<FileItem> items = dextnj.getFileItems();
			
			// FileUpload#getFormItems 메소드를 사용하여 폼 이름으로 클라이언트에서 전달된 메타데이터 콜렉션 객체를 얻을 수 있다.
			List<FormItem> metadata = dextnj.getFormItems("DEXTUploadX5_MetaData");
			
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			FormItem form = null;
			
			for (int i = 0; i < items.size(); i++) {
				file = items.get(i);
				form = metadata.get(i);
				
				if (file.isEmpty() == false) {
					file.save();
					
					// 메타데이터와 저장된 파일의 위치를 응답 데이터 버퍼에 기록한다.
					sb.append(String.format("F:%1$s, M:%2$s\n", file.getFilename(), form.getValue()));
				}
			}
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			throw new ServletException(e);
		} finally {
			if (dextnj != null) dextnj.close();
		}
	}
}
