package sample_x5_nj_servlet_ko;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@SuppressWarnings("serial")
public class FormService extends HttpServlet {
	
    public FormService() {
        super();
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		request.setCharacterEncoding("UTF-8");
		
		// 폼 데이터 정보를 가지고 있는 엔티티 클래스를 DataEntity라고 가정한다.
		DataEntity data = new DataEntity();
		
		data.setText1(request.getParameter("text1"));
		data.setRadio1(request.getParameter("radio1"));
		data.setCheckbox1(request.getParameter("checkbox1"));
		data.setCheckbox2(request.getParameter("checkbox2"));
		data.setCheckbox3(request.getParameter("checkbox3"));
		data.setSelect1(request.getParameter("select1"));
		
		List<FileEntity> files = data.getFiles();
		
		// 새롭게 업로드된 파일 정보를 얻는다.
		String[] tokens = request.getParameter("newFileKeys").split(";");
		for (String key : tokens) {
			if (key.isEmpty() == false) {
				files.add(FileRepository.getFileEntity(key));
			}
		}

		// 삭제할 파일의 정보를 얻는다.
		String strDeleteKeys = request.getParameter("deleteFileKeys");
		if (strDeleteKeys != null && strDeleteKeys.length() > 0) {
			data.setDeleteDescription(strDeleteKeys + " 파일이 삭제되었습니다.");
		} else {
			data.setDeleteDescription("삭제된 파일이 없습니다.");
		}
		
		// DB에 등록했다고 가정한다.
		String key = DataRepository.addDataEntity(data);
		
		if (strDeleteKeys != null) {
			// 만일 삭제된 파일 정보가 있다면, 물리적 파일을 이 시점에 삭제해야 한다.
		}
		
		String referer = request.getHeader("referer");
		response.sendRedirect(referer.substring(0, referer.lastIndexOf("/")).concat("/view-form.jsp?key=").concat(key));		
	}
}
