package sample_x5_nj_servlet_ko;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.CompressUtil;
import devpia.dextuploadnj.support.common.FileDownload;


@SuppressWarnings("serial")
public class FileCompression extends HttpServlet {

	private String fileRoot;
	
    public FileCompression() {
        super();
    }

    public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		fileRoot = config.getServletContext().getRealPath("/files/");
	}
    
    /**
     * GET 요청이 오면, 압축 파일을 다운로드한다.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String compresskey = request.getParameter("compresskey");
		
		FileEntity target = FileRepository.getFileEntity(compresskey);
		if (target != null) {
			FileDownload dextnj = new FileDownload();
			dextnj.setAllowingWeakRange(false);
			dextnj.setRemoveAfterDownloading(true);
			dextnj.download(request, response, target.getFile(), target.getFilename(), null, false, false);
		} else {
			response.sendError(404);
		}		
	}

    /**
     * POST 요청이 오면, 압축을 한 후, 다운로드할 수 있는 경로를 응답 데이터로 반환한다.
     */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		List<File> files = new ArrayList<File>();
		String vindices = request.getParameter("DEXTUploadX5_VIndexes");
		String[] tokens = vindices.split(",");
		for (int i = 0; i < tokens.length; i++) {
			if (tokens[i].equals("IDX0003"))
				files.add(new File(fileRoot, "attach/서강대교_509147.jpg"));
			if (tokens[i].equals("IDX0004"))
				files.add(new File(fileRoot, "attach/우도해변_239826.jpg"));
			if (tokens[i].equals("IDX0005"))
				files.add(new File(fileRoot, "attach/코스모스 (빈공간) 195779.jpg"));
		}
		
		// 임시 위치에 압축 파일을 생성한다.
		CompressUtil cu = new CompressUtil();
		File zipped = cu.zip(files, new File(fileRoot, "/temp/"), "UTF-8", false, false);
		
		// FileEntity, FileRepository 클래스는 DEXTUploadNJ 컴포넌트에서 포함된 클래스가 아니며,
		// 파일을 압축하고 압축된 파일을 다운로드 하는 과정의 이해를 돕기 위해 사용되었다.
		FileEntity target = new FileEntity();
		target.setMime("application/x-zip-compressed");
		target.setFilename(zipped.getName());
		target.setFile(zipped);
		target.setSize(zipped.length());
		
		String compresskey = FileRepository.addFileEntity(target);
		
		response.setContentType("text/plain");		
		response.getWriter().write(request.getRequestURL().append("?compresskey=".concat(compresskey)).toString());
	}

}
