package sample_x5_nj_servlet_ko;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class CommonUpload extends HttpServlet {
	/**
	 * {@link devpia.dextuploadnj.Environment} 클래스는
	 * {@link devpia.dextuploadnj.support.common.FileUpload} 객체가
	 * 파일 업로드를 처리하기 위해 필요로 하는 환경 설정 값들을 가지고 있는 클래스이다.
	 * 서블릿의 init 메소드에서 정의되고, doPost 메소드에서 사용된다.
	 */
	private Environment env;
       
    public CommonUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			// 파일을 저장할 디렉터리와 라이선스 파일 경로를 얻는다. 
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			
			// 일반적으로 서비스되는 위치가 아닌, 외부 디렉터리 및 디바이스 경로를 지정한다.
			// 샘플은 이해를 목적으로 서비스 루트의 files 디렉터리를 사용했다.
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			// 샘플을 구동하기 위한 라이선스 파일 경로 위치를 얻는다.
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();
		
		// 임시 디렉터리 경로, 실제 파일을 저장할 경로 및 기타 설정 사항들을 등록한다.
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			// HTTP 요청 객체와 환경 설정 객체를 인자로 받는 FileUpload 객체를 생성한다. 
			dextnj = new FileUpload(request, env);
			
			// 클라이언트로부터 전송된 데이터로부터 파일 데이터 부분을 모두 임시 파일로 저장한다.
			// 임시 저장 위치는 Environment#setTempRepository 메소드로 설정된다.
			dextnj.prepare();
			
			// FileUpload#getFileItem 메소드를 사용하여 폼 이름으로 하나씩 호출할 수 있지만, getFileItems 메소드를 사용하면 콜렉션 객체를 얻을 수 있다.
			List<FileItem> items = dextnj.getFileItems();
			
			// 응답 데이터를 기록하기 위한 버퍼이다.
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			for (int i = 0; i < items.size(); i++) {
				
				file = items.get(i);
				
				if (file.isEmpty() == false) {
					// 대상이 올바른 파일이라면 실제 저장할 위치로 임시 파일을 저장(복사 혹은 이동)한다.
					// 인자로 주어진 디렉터리 경로가 없다면 Environment#setDefaultRepository 메소드로 설정된 경로가 타깃이 된다.
					file.save();
					
					// 저장된 파일의 위치를 응답 데이터 버퍼에 기록한다.
					sb.append(String.format("F:%1$s\n", file.getFilename()));
				}
			}
			
			// 응답 데이터를 작성한다.
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			// 문제가 생기면 반드시 오류를 발생시켜야 한다.
			// 만일 예외 처리를 하지 않고 싶다면 'response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);' 를 사용하여 HTTP 상태 코드를 오류로 처리해야 한다.
			throw new ServletException(e);
		} finally {
			// 리소스를 제거한다.
			// 삭제가 되지 않은 임시 파일이 있다면 모두 삭제된다.
			if (dextnj != null) dextnj.close();
		}
	}
}
