package sample_x5_nj_servlet_ko;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.support.common.FileDownload;

@SuppressWarnings("serial")
public class CommonDownload extends HttpServlet {
	
	private String fileRoot;
       
    public CommonDownload() {
        super();
    }
    
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		fileRoot = config.getServletContext().getRealPath("/files/attach/");
	}
	
	protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doGet(request, response);
	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		File target = null;
		
		String key = request.getParameter("key");
		
		if (key.equals("FID0001")) target = new File(fileRoot, "서강대교_509147.jpg");
		else if (key.equals("FID0002")) target = new File(fileRoot, "우도해변_239826.jpg");
		else if (key.equals("FID0003")) target = new File(fileRoot, "코스모스 (빈공간) 195779.jpg");
		
		if (target == null  || target.exists() == false || target.isFile() == false) {
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "주어진 키에 해당하는 파일 정보가 없습니다.");
			return;
		}
		
		try {
			
			// FileDownload 객체를 생성한다.
			FileDownload dextnj = new FileDownload();
			
			// 인코딩을 UTF-8로 설정한다.
			response.setCharacterEncoding("UTF-8");
			// HD 응용프로그램을 사용하면 User-Agent 값이 DEXTUploadX5로 시작하는 값(suffix가 다름)을 갖는다.
			if (request.getHeader("User-Agent").indexOf("DEXTUploadX5") >= 0) {
				dextnj.setAllowingWeakRange(true);
				dextnj.download(request, response, target);
			} else {
				dextnj.download(request, response, target, target.getName(), "application/octet-stream", false, false);
			}
			
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
}
