﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_en.service
{
    public class metadata_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();

                var files = dext.GetFileElements("DEXTUploadX5_FileData");
                var meta = dext.GetStringElements("DEXTUploadX5_MetaData");
                var list = files.Zip(meta, (first, second) => new { File = first, Metadata = second });
                
                foreach (var pair in list)
                {
                    if (!pair.File.IsEmpty)
                    {
                        pair.File.Save();
                        sb.AppendFormat("F:{0}, M:{1}\n", pair.File.FileName, pair.Metadata.Value);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}