﻿using sample_x5_net5_en.helper;
using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Linq;
using System.Web;

namespace sample_x5_net5_en.service
{
    public class compress : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Compress(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Compress(HttpContext context)
        {
            var data = context.Request.Form["DEXTUploadX5_VIndexes"] ?? string.Empty;
            var vindexes = data.Split(',');
            var targets = new List<string>();

            foreach (string index in vindexes)
            {
                if (index.Equals("IDX0003")) targets.Add(context.Server.MapPath("~/files/attach/bridge_509147.jpg"));
                else if (index.Equals("IDX0004")) targets.Add(context.Server.MapPath("~/files/attach/beach_239826.jpg"));
                else if (index.Equals("IDX0005")) targets.Add(context.Server.MapPath("~/files/attach/cosmos (empty) 195779.jpg"));
            }

            var zipPath = Path.GetTempFileName();

            using (var fs = new FileStream(zipPath, FileMode.Create))
            using (var za = new ZipArchive(fs, ZipArchiveMode.Create, false, System.Text.Encoding.UTF8))
            {
                foreach (string path in targets)
                {
                    za.CreateEntryFromFile(path, Path.GetFileName(path));
                }
            }

            FileRepository.Clear();
            var key = FileRepository.Add(new FileEntity
            {
                Path = zipPath,
                MimeType = "application/x-zip-compressed",
                FileName = string.Concat(Path.GetFileNameWithoutExtension(zipPath), ".zip")
            });

            UriBuilder b = new UriBuilder(context.Request.Url);
            b.Path = VirtualPathUtility.ToAbsolute("~/service/zip-download.ashx");
            b.Query = string.Concat("key=", key);

            context.Response.ContentType = "text/plain";
            context.Response.Write(b.ToString());
        }
    }
}