﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class exif_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();

                var files = dext.GetFileElements("DEXTUploadX5_FileData");
                // DEXTUploadX5_EXIFData 폼 이름으로부터 EXIF 정보를 얻을 수 있다.
                var exifs = dext.GetStringElements("DEXTUploadX5_EXIFData");
                // 폴더 정보는 파일과 한 쌍을 이룬다.
                var list = files.Zip(exifs, (first, second) => new { File = first, Exif = second });
                var tokens = null as string[];
                var strExif = new StringBuilder();

                foreach (var pair in list)
                {
                    if (!pair.File.IsEmpty)
                    {
                        pair.File.Save();

                        tokens = pair.Exif.Value.Split(new string[] { "[SPLT]" }, StringSplitOptions.RemoveEmptyEntries);

                        strExif.Clear();
                        for (int k = 0, len = tokens.Length; (k + 1) < len; k += 2)
                        {
                            strExif.AppendFormat("{0}:{1}\n", tokens[k], tokens[k + 1]);
                        }

                        sb.AppendFormat("F:{0}\n{1}\n", pair.File.FileName, strExif.ToString());
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}