﻿namespace sample_x5_net5_ko.service
{
	using System;
	using System.Collections.Generic;
	using System.Linq;
	using System.Web;

	using Amazon;
	using Amazon.S3;
	using Amazon.S3.Model;

	public class awss3_download_helper : IHttpHandler
	{
		public class AWSS3DownloadHelper
		{
			public const string ACCESS_KEY = "";
			public const string SECRET_ACCESS_KEY = "";
			public const string REGION = "";
			public const string BUCKET_NAME = "";

			private AmazonS3Client _client;

			public AWSS3DownloadHelper()
			{
				_client = new AmazonS3Client(ACCESS_KEY, SECRET_ACCESS_KEY, RegionEndpoint.GetBySystemName(REGION));
			}


			public string GetPresignedURL(string key)
			{
				return _client.GetPreSignedURL(new GetPreSignedUrlRequest
				{
					BucketName = BUCKET_NAME,
					Key = key,
					Verb = HttpVerb.GET,
					// URL 유효 시간 설정
					Expires = DateTime.UtcNow.AddMinutes(15)
				});
			}
		}

		public void ProcessRequest(HttpContext context)
		{
			var req = context.Request;
			var res = context.Response;

			try
			{
				var key = req.Form["key"];

				if (!string.IsNullOrEmpty(key))
				{
					var helper = new AWSS3DownloadHelper();
					var responseString = helper.GetPresignedURL(key);
					res.ContentType = "application/json";
					res.Write(string.Format("{{ \"url\": \"{0}\" }}", responseString));					
				}
				else
				{
					res.StatusCode = 400;
					res.ContentType = "application/json";
					res.Write("{ \"error\": \"Invalid parameters.\" }");
				}
			}
			catch (Exception ex)
			{
				res.StatusCode = 500;
				res.ContentType = "application/json";
				res.Write(string.Format("{{ \"error\": \"{0}\" }}", ex.Message));
			}
		}

		public bool IsReusable
		{
			get
			{
				return false;
			}
		}
	}
}