package sample_x5_nj_boot_gradle_jar_ko;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import devpia.dextuploadnj.support.spring.DEXTUploadNJSpringExtensionUploadFilter;

@Configuration
public class SampleConfiguration implements WebMvcConfigurer {
	
	public SampleConfiguration(ServletContext context) throws IOException {
		/*
		 * 샘플에 필요한 평가판 서버 라이선스 파일을 추출한다.
		 * 샘플이 아닌 실제 프로젝트에서는 라이선스 파일을 추출하지 않으므로, 아래 코드는 불필요하다.
		 */
		JarUtil.saveResourceToFile("/static/license/dextuploadnj.config", context.getRealPath("/license/dextuploadnj.config"));
		JarUtil.saveResourceToFile("/static/files/attach/DEXTX5_Enc_서강대교_509147.jpg", context.getRealPath("/files/attach/DEXTX5_Enc_서강대교_509147.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/DEXTX5_Enc_우도해변_239826.jpg", context.getRealPath("/files/attach/DEXTX5_Enc_우도해변_239826.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/DEXTX5_Enc_코스모스_195779.jpg", context.getRealPath("/files/attach/DEXTX5_Enc_코스모스_195779.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/logo_dextsolution.png", context.getRealPath("/files/attach/logo_dextsolution.png"));
		JarUtil.saveResourceToFile("/static/files/attach/서강대교_509147.jpg", context.getRealPath("/files/attach/서강대교_509147.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/우도해변_239826.jpg", context.getRealPath("/files/attach/우도해변_239826.jpg"));		
		JarUtil.saveResourceToFile("/static/files/attach/코스모스 (빈공간) 195779.jpg", context.getRealPath("/files/attach/코스모스 (빈공간) 195779.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/compress/서강대교_509147.jpg", context.getRealPath("/files/attach/compress/서강대교_509147.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/compress/우도해변_239826.jpg", context.getRealPath("/files/attach/compress/우도해변_239826.jpg"));
		JarUtil.saveResourceToFile("/static/files/attach/compress/sub_B/코스모스 (빈공간) 195779.jpg", context.getRealPath("/files/attach/compress/sub_B/코스모스 (빈공간) 195779.jpg"));
		new File(context.getRealPath("/files/attach/compress/sub_A")).mkdirs();
	}
	
	@Override
	public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
		// DEXTUploadX5Item 형식의 매개변수를 처리하기 위한 ArgumentResolver이다. 주로 대용량 파일 업로드에서 사용된다.
		argumentResolvers.add(new DEXTUploadX5ItemArgumentResolver());
		// DEXTUploadX5List 형식의 매개변수를 처리하기 위한 ArgumentResolver이다. 주로 일반 파일 업로드에서 사용된다.
		argumentResolvers.add(new DEXTUploadX5ListArgumentResolver());		
		// ** DEXTUploadX5Item, DEXTUploadX5List, DEXTUploadX5ItemArgumentResolver, DEXTUploadX5ListArgumentResolver 모두 참고용 클래스로서 배포 패키지에는 포함되어 있지 않다.
	}

	/**
	 * DEXTUploadNJ DEXTUploadNJSpringExtensionUploadFilter 객체를 설정한다.
	 * DEXTUploadNJSpringExtensionUploadFilter는 일반 업로드부터 대용량 업로드까지 모두 처리할 수 있다.
	 * @return FilterRegistrationBean 객체
	 */
	@Bean
	FilterRegistrationBean<DEXTUploadNJSpringExtensionUploadFilter> filterRegistrationBean(ServletContext context) {
		FilterRegistrationBean<DEXTUploadNJSpringExtensionUploadFilter> fb = new FilterRegistrationBean<DEXTUploadNJSpringExtensionUploadFilter>();
		fb.addInitParameter("tempRepository", "/files/temp");
		fb.addInitParameter("defaultRepository", "/files/store");
		fb.addInitParameter("autoMakingDirectory", "true");
		fb.addInitParameter("enableCleaner", "true");
		fb.addInitParameter("whiteExtension", "jpg,gif,png,doc,xls,ppt,docx,xlsx,pptx,pdf,txt,zip,hwp,mp4");
		/*
		 * 서버 라이선스를 사용하고자 할 때,
		 * 샘플에서는 SampleConfiguration 생성자에서 추출한 dextuploadnj.config 파일을 라이선스 파일로 설정하고 있다.
		 * 그러나 실제 프로젝트에서는 외부의 dextuploadnj.config 파일의 전체 경로를 설정해줘야 한다.
		 */
		fb.addInitParameter("licenseFilePath", context.getRealPath("/license/dextuploadnj.config"));		
		/*
		 * 도메인 라이선스를 사용하고자 할 때,
		 * fb.addInitParameter("licenseFilePath", "dextuploadnj.config 파일 경로") <- 이 부분을 제거하고
		 * 다음의 코드를 사용하여 라이선스를 적용한다.
		 * fb.addInitParameter("licenseAuthKey", "FSFzEQy... 도메인 라이선스 인증키 ...XCLGZuc=");
		 */
		fb.setFilter(new DEXTUploadNJSpringExtensionUploadFilter());
		//fb.setOrder(10);
		// 클라이언트의 요청에만 동작하도록 한다.
		fb.setDispatcherTypes(DispatcherType.REQUEST);
		/*
		 * upload-simple: 일반 파일 업로드 예제 매핑 경로
		 * upload-metadata: 메타데이터를 포함한 파일 업로드 예제 매핑 경로
		 * upload-oraf: ORAF 업로드 예제 매핑 경로
		 * upload-orof: OROF 업로드 예제 매핑 경로
		 * upload-files: 게시판 업로드 예제 매핑 경로
		 * upload-multiple: 다중 컴포넌트 업로드 예제 매핑 경로
		 * upload-folder: 폴더 업로드 예제 매핑 경로
		 * upload-exif: EXIF 어볼드 예제 매핑 경로
		 * upload-extension: 대용량 파일 업로드 예제 매핑 경로
		 */
		fb.addUrlPatterns(
				"/upload-simple", 
				"/upload-metadata", 
				"/upload-oraf", 
				"/upload-orof", 
				"/upload-files", 
				"/upload-multiple",
				"/upload-folder",
				"/upload-exif",
				"/upload-extension");
		return fb;
	}

}
