package sample_x5_nj_boot_gradle_jar_ko;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.springframework.core.io.ClassPathResource;

import devpia.dextuploadnj.NJIoUtil;

/**
 * 아래 내요은 DEXTUploadNJ 서버 라이선스를 사용하는 경우에만 해당한다.
 * -----------------------------------------------------------------------------------------
 * DEXTUploadNJ 제품은 구동 시점에 라이선스 인증을 하기 위해서 라이선스 파일이 필요한데,
 * 샘플 프로젝트 특성상 라이선스 파일을 JAR 파일에 함께 포함하여 배포를 하기 때문에, 
 * 웹애플리케이션 실행 시점에 라이선스 파일을 추출하는 작업이 필요하며, 이때 JarUtil 클래스를 사용한다.
 * 샘플과 다르게 실제 프로젝트에서는 라이선스 파일을 따로 관리해주어야 한다.
 * 만약 라이선스 파일을 따로 관리하지 않고, 함께 배포를 해야 한다면 서버 라이선스가 아닌 도메인 라이선스를 사용할 것을 권장한다.
 */
public class JarUtil {
	
	private JarUtil() {}
	
	private static void saveResourceToFile(ClassPathResource source, File destiny) throws IOException {
		FileOutputStream fos = null;
		try {
			if (!source.exists()) throw new IOException(String.format("%s resource does not exist.", source.getPath()));
			if (!destiny.getParentFile().exists()) destiny.getParentFile().mkdirs();
			InputStream ris = source.getInputStream();
			fos = new FileOutputStream(destiny);
			NJIoUtil.copy(ris, fos);
		} catch (IOException e) { throw e; } finally { NJIoUtil.closeIO(fos); }
	}
	
	public static void saveResourceToFile(String resourcePath, String outFilePath) throws IOException {
		ClassPathResource resource = new ClassPathResource(resourcePath);
		File file = new File(outFilePath);
		saveResourceToFile(resource, file);
	}

}
