package sample_x5_nj_boot_gradle_jar_ko;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * FakeFileService 클래스는 예제를 위해서 파일 정보를 DB와 같은 다른 미디어에서 관리하는 것처럼 흉내를 내는 용도로 만들어졌다.
 */
public class FakeFileService {
	
	private static int incrementableKey = 0;
	private static final Map<String, FakeFile> repository = new HashMap<String, FakeFile>();
	private static final Map<String, List<String>> group = new HashMap<String, List<String>>();
	
	private static String getCurrentSessionId() {
		ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
		return attr.getSessionId();
	}
	
	private static List<String> getSessionGroup(String sessionId) {
		if (sessionId == null) sessionId = getCurrentSessionId();
		List<String> sessionGroup = null;
		if (group.containsKey(sessionId)) sessionGroup = group.get(sessionId);
		else {
			sessionGroup = new ArrayList<String>();
			group.put(sessionId, sessionGroup);
		}
		return sessionGroup;
	}
	
	public static synchronized String add(FakeFile entity) {
		String sessionId = getCurrentSessionId();
		String key = String.format("F%s_%05d", sessionId, ++incrementableKey);
		entity.setKey(key);
		repository.put(key, entity);
		List<String> sessionGroup = getSessionGroup(sessionId);
		sessionGroup.add(key);
		return key;
	}
	
	public static FakeFile get(String key) {
		return repository.containsKey(key) ? repository.get(key) : null;
	}
	
	public static List<FakeFile> getSessionList() {
		String sessionId = getCurrentSessionId();
		List<FakeFile> list = new ArrayList<FakeFile>();
		for (String key : getSessionGroup(sessionId)) {
			list.add(repository.get(key));
		}
		return list;		
	}
	
	public static synchronized void clear() {		
		group.clear();
		repository.clear();
		incrementableKey = 0;		
	}
	
	public static synchronized void clearSession() {
		String sessionId = getCurrentSessionId();
		for (String key : getSessionGroup(sessionId)) {
			if (repository.containsKey(key)) repository.remove(key);
		}
		group.remove(sessionId);
	}
}
