package sample_x5_nj_servlet_ja;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataRepository {

	private static int incrementableKey = 0;
	private static final Map<String, DataEntity> repository = new HashMap<String, DataEntity>();
	
	public static synchronized String addDataEntity(DataEntity entity) {
		String key = String.format("D%1$05d", ++incrementableKey);
		repository.put(key, entity);
		entity.setKey(key);
		return key;
	}
	
	public static DataEntity getDataEntity(String key) {
		if (repository.containsKey(key))
			return repository.get(key);
		else
			return null;
	}
	
	public static List<DataEntity> getDataEntities() {
		Set<String> keys = repository.keySet();
		return getDataEntities(Utils.toList(keys.toArray(new String[keys.size()])));
	}
	
	public static List<DataEntity> getDataEntities(List<String> keys) {
		List<DataEntity> list = new ArrayList<DataEntity>();
		Iterator<String> iterator = keys.iterator();
		DataEntity temp = null;
		while (iterator.hasNext()) {
			temp = getDataEntity(iterator.next());
			if (temp != null) list.add(temp);
		}
		return list;	
	}
	
	public static synchronized void clear() {
		repository.clear();
		incrementableKey = 0;
	}
}
