package sample_x5_nj_servlet_ja;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.sas.SasProtocol;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AzureSasTokenGenerator {
	
	private final static String ACCOUNT_NAME = "";
	private final static String CONTAINER_NAME = "";
	private final static String ACCESSKEY = "";
	
	public String generateBlobListSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
        // SAS 有効期限（サーバー時間差補正：5分早く開始、1時間有効）
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 権限：読み取り + リスト（未コミットブロックのリストを読み取るために必要）
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true)
                .setListPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Blob に基づいて SAS トークンを生成
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}
	
	public String generateContainerSasToken() {
        	
    	StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
    	
        // SAS 有効期限（サーバー時間差補正：5分早く開始、1時間有効）
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 権限: 作成 + 書き込み (新しいBlobを作成するため)
        BlobSasPermission permissions = new BlobSasPermission()
        		.setCreatePermission(true)
        		.setWritePermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);	        
        
    	// コンテナに基づいて SAS トークンを生成
        String sasToken = containerClient.generateSas(sasValues);
        
        return sasToken;
        
	}
	
	public String generateBlobSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
        // SAS 有効期限（サーバー時間差補正：5分早く開始、1時間有効）
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 権限: 読み取り (Blobの内容を読み取るために必要)
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Blob に基づいて SAS トークンを生成
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}

}
