package sample_x5_nj_servlet_ja;

import java.io.IOException;
import java.util.Optional;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SuppressWarnings("serial")
public class AZRBSList extends HttpServlet {

    public AZRBSList() {
        super();
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		request.setCharacterEncoding("UTF-8");
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		
		try {
			
			String key = Optional.ofNullable(request.getParameter("key")).orElse("");
			
			if (!key.isEmpty()) {
				AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
				String token = gen.generateBlobListSasToken(key);
				response.getWriter().write(token);
			} else {		
				response.setStatus(400);
				response.getWriter().write("Invalid parameters");
			}
			
		} catch (Exception ex) {
			response.setStatus(500);
			response.getWriter().write(ex.getMessage());
		}
	}

}
