package sample_x5_jk_boot_gradle_jar_ko;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AZRBSController {
	
	@PostMapping(value = "/get-list-sastoken", produces = "text/plain;charset=UTF-8")
	public ResponseEntity<Object> getListSasToken(@RequestParam(value = "key", required = false, defaultValue = "") String key) {
		
		if (!key.isEmpty()) {
			AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
			String token = gen.generateBlobListSasToken(key);
			return new ResponseEntity<>(token, HttpStatus.OK);
		} else {
			return new ResponseEntity<>("Invalid parameters", HttpStatus.BAD_REQUEST);
		}
	}
	
	@GetMapping(value = "/get-upload-sastoken", produces = "text/plain;charset=UTF-8")
	public ResponseEntity<Object> getUploadSasToken() {
		
		AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
		String token = gen.generateContainerSasToken();
		return new ResponseEntity<>(token, HttpStatus.OK);
	}
	
	@PostMapping(value = "/get-download-sastoken", produces = "text/plain;charset=UTF-8")
	public ResponseEntity<Object> getDownloadSasToken(@RequestParam(value = "key", required = false, defaultValue = "") String key) {
		
		if (!key.isEmpty()) {
			AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
			String token = gen.generateBlobSasToken(key);
			return new ResponseEntity<>(token, HttpStatus.OK);
		} else {
			return new ResponseEntity<>("Invalid parameters", HttpStatus.BAD_REQUEST);
		}
	}
}
