﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DEXTUpload.NET.Mvc;

namespace sample_x5_net5_mvc5_ko.Controllers
{
    public class ExtensionSampleController : Controller
    {
        public ActionResult Ex001() { return View(); }
        public ActionResult Ex002() { return View(); }

        [HttpPost]
        public ActionResult SubmitForm(DataEntity entity, string nfiles, string ofiles, string dfiles)
        {
            // 새로 추가된 파일들의 키 목록 문자열을 얻는다.
            entity.NewFiles.AddRange(nfiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)).Select(k => FileRepository.Get(k)));
            // 기존 파일들의 키 목록 문자열을 얻는다.
            entity.OldFiles.AddRange(ofiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)));
            // 삭제된 파일들의 키 목록 문자열을 얻는다.
            entity.DeletedFiles.AddRange(dfiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)));

            // DataRepository 클래스는 업로드된 정보들을 기록하는 레파지토리(일종의 DB 역할의 의미) 클래스이다.
            // DataEntity 클래스와 마찬가지로 샘플 구성과 이해를 돕기 위해서 작성되었다.
            var key = DataRepository.Add(entity);

            if (entity.DeletedFiles.Count > 0)
            {
                // 파일을 삭제하는 작업은 데이터베이스 트랜잭션이 끝난 후에 처리하는 것을 권장한다.
            }

            return RedirectToAction("ViewResult", new { key = key });
        }

        [HttpGet]
        public ActionResult ViewResult(string key)
        {
            var entity = DataRepository.Get(key);
            return View(entity);
        }
    }
}