﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_mvc5_en
{
    public static class DataRepository
    {
        private static int _incrementableKey = 0;
        private static Dictionary<string, DataEntity> _repository = new Dictionary<string, DataEntity>();

        public static string Add(DataEntity entity)
        {
            lock (_repository)
            {
                var key = string.Format("D{0:00000}", ++_incrementableKey);
                entity.Key = key;
                _repository.Add(key, entity);
                return key;
            }
        }

        public static DataEntity Get(string key)
        {
            if (_repository.ContainsKey(key))
                return _repository[key];
            else
                return null;
        }

        public static IEnumerable<DataEntity> ToList()
        {
            return from p in _repository select p.Value;
        }

        public static void Clear()
        {
            lock (_repository)
            {
                _repository.Clear();
            }
        }
    }
}