﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DEXTUpload.NET.Mvc;

namespace sample_x5_net5_mvc5_en.Controllers
{
    public class ExtensionSampleController : Controller
    {
        public ActionResult Ex001() { return View(); }
        public ActionResult Ex002() { return View(); }

        [HttpPost]
        public ActionResult SubmitForm(DataEntity entity, string nfiles, string ofiles, string dfiles)
        {
            // Get a key list string of the newly added files.
            entity.NewFiles.AddRange(nfiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)).Select(k => FileRepository.Get(k)));
            // Get the key list string of the existing files.
            entity.OldFiles.AddRange(ofiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)));
            // Get the key list string of deleted files.
            entity.DeletedFiles.AddRange(dfiles.Split(';').Where(n => !string.IsNullOrWhiteSpace(n)));

            // The DataEntity and the DataRepository class are dummy classes used for helping to show the result of uploading.
            var key = DataRepository.Add(entity);

            if (entity.DeletedFiles.Count > 0)
            {
                // It is recommended to delete the file after the database transaction.
            }

            return RedirectToAction("ViewResult", new { key = key });
        }

        [HttpGet]
        public ActionResult ViewResult(string key)
        {
            var entity = DataRepository.Get(key);
            return View(entity);
        }
    }
}