﻿namespace sample_x5_net5_mvc5_en.Controllers
{
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Web;
    using System.Web.Mvc;

    public class AzureBlobStorageSampleController : Controller
    {
        public ActionResult Ex001() { return View(); }
        public ActionResult Ex002() { return View(); }

        [HttpPost]
        public ActionResult GetListSasToken(string key)
        {
            if (!string.IsNullOrEmpty(key))
            {
                var gen = new AzureSasTokenGenerator();
                // If sent with POST application/x-www-form-urlencoded encoding, the key is encoded and needs to be decoded.
                var sasToken = gen.GenerateListSasToken(HttpUtility.UrlDecode(key).Replace("%20", "+"));
                return Content(sasToken, "text/plain", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "Invalid parameters.");
            }
        }

        [HttpGet]
        public ActionResult GetUploadSasToken()
        {
            var gen = new AzureSasTokenGenerator();
            var sasToken = gen.GenerateContainerSasToken();
            return Content(sasToken, "text/plain", Encoding.UTF8);
        } 

        [HttpPost]
        public ActionResult GetDownloadSasToken(string key)
        {
            if (!string.IsNullOrEmpty(key))
            {
                var gen = new AzureSasTokenGenerator();
                // If sent with POST application/x-www-form-urlencoded encoding, the key is encoded and needs to be decoded.
                var sasToken = gen.GenerateBlobSasToken(HttpUtility.UrlDecode(key).Replace("%20", "+"));
                return Content(sasToken, "text/plain", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "Invalid parameters.");
            }
        }
    }
}