﻿namespace sample_x5_net5_mvc5_en
{
	using System;
	using Azure.Storage;
	using Azure.Storage.Sas;

	public class AzureSasTokenGenerator
	{
		public const string ACCOUNT_NAME = "";
		public const string CONTAINER_NAME = "";
		// Container's AccessKey
		public const string ACCOUNT_KEY = "";

		public AzureSasTokenGenerator()
		{
		}

		public string GenerateListSasToken(string blobName)
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// We need to create a shared access token with an unencoded name.
				BlobName = blobName,
				// Set the resource scope to Blob.
				Resource = "b",
				// Set the start time about 5 minutes earlier due to the time difference between servers.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// Valid for 1 hour
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};
			// The shared access token needs Read, List permission to read the list of uncommitted blocks.
			sasBuilder.SetPermissions(BlobAccountSasPermissions.Read | BlobAccountSasPermissions.List);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}

		public string GenerateContainerSasToken()
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// Set the resource scope to container.
				Resource = "c",
				// Set the start time about 5 minutes earlier due to the time difference between servers.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// Valid for 1 hour
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};

			// The shared access token needs Create, Write permission to upload files.
			sasBuilder.SetPermissions(BlobAccountSasPermissions.Write | BlobAccountSasPermissions.Create);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}

		public string GenerateBlobSasToken(string blobName)
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// We need to create a shared access token with an unencoded name.
				BlobName = blobName,
				// Set the resource scope to Blob.
				Resource = "b",
				// Set the start time about 5 minutes earlier due to the time difference between servers.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// Valid for 1 hour
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};

			sasBuilder.SetPermissions(BlobAccountSasPermissions.Read);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}
	}
}