﻿namespace sample_x5_net5_mvc5_en
{
	using Amazon;
	using Amazon.S3;
	using Amazon.S3.Model;
	using Newtonsoft.Json;
	using System;
	using System.Collections.Generic;

	public class AWSS3MultipartUploadHelper
	{
		public const string ACCESS_KEY = "";
		public const string SECRET_ACCESS_KEY = "";
		public const string REGION = "";
		public const string BUCKET_NAME = "";

		private AmazonS3Client _client;

		public AWSS3MultipartUploadHelper()
		{
			_client = new AmazonS3Client(ACCESS_KEY, SECRET_ACCESS_KEY, RegionEndpoint.GetBySystemName(REGION));
		}

		private S3CannedACL FromStringToCannedACL(string acl)
		{
			switch (acl)
			{
				case "public-read": return S3CannedACL.PublicRead;
				case "public-read-write": return S3CannedACL.PublicReadWrite;
				case "authenticated-read": return S3CannedACL.AuthenticatedRead;
				case "aws-exec-read": return S3CannedACL.AWSExecRead;
				case "bucket-owner-read": return S3CannedACL.BucketOwnerRead;
				case "bucket-owner-full-control": return S3CannedACL.BucketOwnerFullControl;
				default: return S3CannedACL.Private;
			}
		}

		private S3StorageClass FromStringToStorageClass(string storageClass)
		{
			switch (storageClass)
			{
				case "STANDARD_IA": return S3StorageClass.StandardInfrequentAccess;
				case "REDUCED_REDUNDANCY": return S3StorageClass.ReducedRedundancy;
				case "ONEZONE_IA": return S3StorageClass.OneZoneInfrequentAccess;
				case "INTELLIGENT_TIERING": return S3StorageClass.IntelligentTiering;
				case "GLACIER": return S3StorageClass.Glacier;
				case "DEEP_ARCHIVE": return S3StorageClass.DeepArchive;
				default: return S3StorageClass.Standard;
			}
		}

		public string InitializeUpload(string key, string storageClass, string acl, string contentType, string metaString)
		{
			var request = new InitiateMultipartUploadRequest
			{
				BucketName = BUCKET_NAME,
				Key = key,
				ContentType = contentType,
				StorageClass = FromStringToStorageClass(storageClass),
				CannedACL = FromStringToCannedACL(acl)
			};

			var dictionary = JsonConvert.DeserializeObject<Dictionary<string, string>>(metaString);
			var list = new List<KeyValuePair<string, string>>(dictionary);
			foreach (var pair in list)
			{
				request.Metadata.Add(pair.Key, pair.Value);
			}

			InitiateMultipartUploadResponse initiatedResponse = _client.InitiateMultipartUpload(request);

			return string.Format("{{ \"uid\": \"{0}\", \"key\": \"{1}\", \"url\": \"https://{2}.s3.{3}.amazonaws.com/{1}\" }}", initiatedResponse.UploadId, initiatedResponse.Key, BUCKET_NAME, REGION);
		}

		public string GetPresignedURL(string key, string uid, int partNumber)
		{
			return string.Format("{{ \"url\": \"{0}\" }}", _client.GetPreSignedURL(new GetPreSignedUrlRequest
			{
				BucketName = BUCKET_NAME,
				Key = key,
				UploadId = uid,
				PartNumber = partNumber,
				Verb = HttpVerb.PUT,
				Expires = DateTime.UtcNow.AddMinutes(15)
			}));
		}

		public string CompleteUpload(string key, string uid, List<PartETag> partETags)
		{
			CompleteMultipartUploadResponse completedResponse = _client.CompleteMultipartUpload(new CompleteMultipartUploadRequest
			{
				BucketName = BUCKET_NAME,
				Key = key,
				UploadId = uid,
				PartETags = partETags
			});

			return string.Format("{{ \"location\": \"{0}\" }}", completedResponse.Location);
		}

		public void AbortUpload(string key, string uid)
		{
			_client.AbortMultipartUpload(new AbortMultipartUploadRequest
			{
				BucketName = BUCKET_NAME,
				Key = key,
				UploadId = uid
			});
		}
	}
}