﻿using sample_x5_net5_ko.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class zip_download : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Download(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Download(HttpContext context)
        {
            var key = context.Request.QueryString["key"] ?? string.Empty;
            var entry = FileRepository.Get(key);

            if (entry != null)
            {
                using (var dext = new DEXTUpload.NET.FileDownload())
                {
                    dext.Download(entry.Path, entry.FileName, new DEXTUpload.NET.DownloadOption
                    {
                        // 다운로드를 한 후 압축 파일은 무의미한 파일이므로 삭제하도록 한다.
                        RemoveAfterDownloading = true,
                        // 압축 파일은 매 요청마다 생성되므로 클라이언트 캐시를 사용하지 않도록 한다.
                        UseClientCache = false,
                        // application/x-zip-compressed
                        MimeType = entry.MimeType
                    });
                }
            }
            else
            {
                throw new HttpException(404, "The zip file not found.");
            }
        }
    }
}