﻿using sample_x5_net5_ko.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class upload_service : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();
                var key = null as string;

                foreach (var element in dext.GetFileElements("DEXTUploadX5_FileData"))
                {
                    if (!element.IsEmpty)
                    {
                        element.Save();

                        // FileEntity 클래스는 업로드된 파일를 담고 있는 엔티티 형식의 클래스이다.
                        // FileRepository 클래스는 업로드된 정보들을 기록하는 레파지토리(일종의 DB 역할의 의미) 클래스이다.
                        // 두 클래스는 샘플 구성과 이해를 돕기 위해서 작성되었다.
                        key = FileRepository.Add(new FileEntity
                        {
                            FileName = element.FileName,
                            SavedFileName = element.LastSavedFileName,
                            MimeType = element.MimeType,
                            Size = element.OriginalFileLength,
                            SavedSize = element.FileLength,
                            Path = element.LastSavedFilePath
                        });

                        sb.AppendFormat("{0};", key);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}