﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class multiple_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();

                var files = dext.GetFileElements("DEXTUploadX5_FileData");
                // DEXTUploadX5_ControlId 폼 이름으로부터 컴포넌트 아이디를 얻을 수 있다.
                var cids = dext.GetStringElements("DEXTUploadX5_ControlId");
                // DEXTUploadX5_UniqueId 폼 이름으로부터 파일의 아이디를 얻을 수 있다.
                var uids = dext.GetStringElements("DEXTUploadX5_UniqueId");

                var list = files
                    .Zip(cids, (first, second) => new { File = first, ControlId = second })
                    .Zip(uids, (first, second) => new { File = first.File, ControlId = first.ControlId, UniqueId = second });

                foreach (var pair in list)
                {
                    if (!pair.File.IsEmpty)
                    {
                        pair.File.Save();
                        sb.AppendFormat("{0}|{1}|{2}\n", pair.ControlId.Value, pair.UniqueId.Value, pair.File.FileName);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}