﻿namespace sample_x5_net5_ko.service
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Azure.Storage;
    using Azure.Storage.Sas;

    public class get_upload_sastoken : IHttpHandler
    {
        const string ACCOUNT_NAME = "";
        const string CONTAINER_NAME = "";
        // 컨테이너의 액세스키
        const string ACCOUNT_KEY = "";

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";

            try
            {
                var sasToken = GenerateContainerSasToken(ACCOUNT_NAME, ACCOUNT_KEY, CONTAINER_NAME);
                context.Response.Write(sasToken);
            }
            catch (Exception ex)
            {
                context.Response.StatusCode = 500;
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private string GenerateContainerSasToken(string accountName, string accountKey, string containerName)
        {
            var credential = new StorageSharedKeyCredential(accountName, accountKey);
            var sasBuilder = new BlobSasBuilder
            {
                BlobContainerName = containerName,
                // 리소스 범위를 컨테이너로 설정한다.
                Resource = "c",
                // 서버 간 시간 차가 있기 때문에 시작 시간을 5분 정도 일찍 설정한다.
                StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
                // 1시간 유효
                ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
            };

            // 파일을 업로드하기 위한 공유액세스 토큰은 Create, Write 권한이 필요하다.
            sasBuilder.SetPermissions(BlobAccountSasPermissions.Write | BlobAccountSasPermissions.Create);

            var sasToken = sasBuilder.ToSasQueryParameters(credential);

            return sasToken.ToString();
        }
    }
}