﻿namespace sample_x5_net5_ko.service
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Azure.Storage;
    using Azure.Storage.Sas;

    public class get_list_sastoken : IHttpHandler
    {
        const string ACCOUNT_NAME = "";
        const string CONTAINER_NAME = "";
        // 컨테이너의 액세스키
        const string ACCOUNT_KEY = "";

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";

            try
            {
                var blobName = context.Request.Form["key"] ?? "";
                // POST application/x-www-form-urlencoded 인코딩으로 전송된 경우 key는 인코딩된 상태이므로 디코딩이 필요하다.
                var sasToken = GenerateBlockListSasToken(ACCOUNT_NAME, ACCOUNT_KEY, CONTAINER_NAME, HttpUtility.UrlDecode(blobName).Replace("%20", "+"));
                context.Response.Write(sasToken);
            }
            catch (Exception ex)
            {
                context.Response.StatusCode = 500;
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private string GenerateBlockListSasToken(string accountName, string accountKey, string containerName, string blobName)
        {
            var credential = new StorageSharedKeyCredential(accountName, accountKey);
            var sasBuilder = new BlobSasBuilder
            {
                BlobContainerName = containerName,
                // 인코딩되지 않은 이름으로 공유액세스 토큰을 만들어야 한다.
                BlobName = blobName,
                // 리소스 범위를 Blob으로 설정한다.
                Resource = "b",
                // 서버 간 시간 차가 있기 때문에 시작 시간을 5분 정도 일찍 설정한다.
                StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
                // 1시간 유효
                ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
            };
            // 커밋되지 않은 블록 목록을 읽기 위한 공유액세스 토큰은 Read, List 권한이 필요하다.
            sasBuilder.SetPermissions(BlobAccountSasPermissions.Read | BlobAccountSasPermissions.List);

            var sasToken = sasBuilder.ToSasQueryParameters(credential);

            return sasToken.ToString();
        }
    }
}