﻿using sample_x5_net5_ko.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class extension_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var key = null as string;
                var element = dext.GetSingleFileElement();

                if (!element.IsEmpty)
                {
                    element.Save();

                    key = FileRepository.Add(new FileEntity
                    {
                        FileName = element.FileName,
                        SavedFileName = element.LastSavedFileName,
                        MimeType = element.MimeType,
                        Size = element.OriginalFileLength,
                        SavedSize = element.FileLength,
                        Path = element.LastSavedFilePath
                    });
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(key ?? string.Empty);
            }
        }
    }
}