﻿using sample_x5_net5_ko.helper;
using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Linq;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class compress : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Compress(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Compress(HttpContext context)
        {
            // DEXTUploadX5_VIndexes 폼 이름으로부터 압축할 대상의 가상 인덱스 집합을 얻을 수 있다.
            var data = context.Request.Form["DEXTUploadX5_VIndexes"] ?? string.Empty;
            var vindexes = data.Split(',');
            var targets = new List<string>();

            foreach (string index in vindexes)
            {
                if (index.Equals("IDX0003")) targets.Add(context.Server.MapPath("~/files/attach/서강대교_509147.jpg"));
                else if (index.Equals("IDX0004")) targets.Add(context.Server.MapPath("~/files/attach/우도해변_239826.jpg"));
                else if (index.Equals("IDX0005")) targets.Add(context.Server.MapPath("~/files/attach/코스모스 (빈공간) 195779.jpg"));
            }

            var zipPath = Path.GetTempFileName();

            // .NET Framework 4.5 부터 지원하는 ZipArchive를 이용하여 압축 파일을 생성한다.
            using (var fs = new FileStream(zipPath, FileMode.Create))
            using (var za = new ZipArchive(fs, ZipArchiveMode.Create, false, System.Text.Encoding.UTF8))
            {
                foreach (string path in targets)
                {
                    za.CreateEntryFromFile(path, Path.GetFileName(path));
                }
            }

            // 예제가 아닌 실제 상황에서는 세션 또는 데이터베이스와 같은 다른 저장 방식을 이용하여
            // 실제로 다운로드를 수행해야 하는 핸들러(zip-download.ashx)에서 압축 파일의 경로를 얻을 수 있도록 처리해야 한다.
            // FileRepository 및 FileEntity 클래스는 샘플 구성과 이해를 돕기 위해서 작성되었다.

            FileRepository.Clear();
            var key = FileRepository.Add(new FileEntity
            {
                Path = zipPath,
                MimeType = "application/x-zip-compressed",
                FileName = string.Concat(Path.GetFileNameWithoutExtension(zipPath), ".zip")
            });

            // 압축된 파일을 다운로드할 수 있는 핸들러 경로를 생성한다.
            UriBuilder b = new UriBuilder(context.Request.Url);
            b.Path = VirtualPathUtility.ToAbsolute("~/service/zip-download.ashx");
            b.Query = string.Concat("key=", key);

            // 압축된 파일을 다운로드할 수 있는 경로를 응답 데이터에 실어 클라이언트에 전달해야 한다.
            context.Response.ContentType = "text/plain";
            context.Response.Write(b.ToString());
        }
    }
}