﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class common_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            // Web.config에서 기본 경로를 ~/files/store 설정되었다. 기본 경로를 변경하려면 DefaultPath 속성을 사용한다.
            // ex) dext.DefaultPath = context.Server.MapPath("~/files/store");

            // 서버에서 파일 업로드를 처리할 때 FileUpload 클래스를 사용한다.
            // FileUpload 클래스는 using 문을 사용하는 것을 권장한다.
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();

                // GetFileElements 메소드를 사용하여 업로드된 파일 목록 객체를 얻을 수 있다.
                foreach (var element in dext.GetFileElements("DEXTUploadX5_FileData"))
                {
                    if (!element.IsEmpty)
                    {
                        // 파일을 저장한다.
                        element.Save();
                        sb.AppendFormat("{0}\n", element.FileName);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}