﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_ko.service
{
    public class common_download : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Download(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Download(HttpContext context)
        {
            var key = context.Request.QueryString["key"] ?? string.Empty;
            var path = null as string;

            if (key.Equals("FID0001")) path = "~/files/attach/서강대교_509147.jpg";
            else if (key.Equals("FID0002")) path = "~/files/attach/우도해변_239826.jpg";
            else if (key.Equals("FID0003")) path = "~/files/attach/코스모스 (빈공간) 195779.jpg";
            else throw new HttpException(404, "The target not found.");

            using (var dext = new DEXTUpload.NET.FileDownload())
            {   
                dext.Download(path, new DEXTUpload.NET.DownloadOption {
                    // Usage Agent 값이 DEXTUploadX5로 시작하면 DEXTUploadX5 IE 모듈에서 요청을 한 것이다.
                    AllowingWeakRange = (context.Request.UserAgent.IndexOf("DEXTUploadX5") >= 0)
                });
            }
            // 다운로드 작업 이후에는 Response 객체에 데이터를 쓰는 작업은 절대로 하면 안된다.
        }
    }
}