﻿using sample_x5_net5_ko.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_ko.multi
{
    public class form_process : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Process(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Process(HttpContext context)
        {
            // DataEntity 클래스는 업로드된 정보를 담고 있는 엔티티 형식의 클래스이다.
            // 이 클래스는 샘플 구성을 위해 작성된 클래스로써 제품에 포함된 클래스가 아니다.
            // 파일을 업로드/다운로드하는 과정의 이해를 돕기 위해서 사용된다.
            var entity = new DataEntity
            {
                Text = context.Request.Form["text1"] ?? string.Empty,
                Radio = (RadioOption)Enum.Parse(typeof(RadioOption), context.Request.Form["radio1"], true),
                Bird = !string.IsNullOrWhiteSpace(context.Request.Form["checkbox1"] ?? string.Empty),
                Lion = !string.IsNullOrWhiteSpace(context.Request.Form["checkbox2"] ?? string.Empty),
                Shark = !string.IsNullOrWhiteSpace(context.Request.Form["checkbox3"] ?? string.Empty),
                Selection = (SelectOption)Enum.Parse(typeof(SelectOption), context.Request.Form["select1"], true)
            };

            // 새로 추가된 파일들의 키 목록 문자열을 얻는다.
            var nkeys = context.Request.Form["nfiles"];
            if (!string.IsNullOrWhiteSpace(nkeys))
            {
                entity.NewFiles.AddRange(nkeys.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries).Select(k => FileRepository.Get(k)));
            }

            // 기존 파일들의 키 목록 문자열을 얻는다.
            var okeys = context.Request.Form["ofiles"];
            if (!string.IsNullOrWhiteSpace(okeys))
            {
                entity.OldFiles.AddRange(okeys.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries));
            }

            // 삭제된 파일들의 키 목록 문자열을 얻는다.
            var dkeys = context.Request.Form["dfiles"];
            if (!string.IsNullOrWhiteSpace(dkeys))
            {
                entity.DeletedFiles.AddRange(dkeys.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries));
            }

            // DataRepository 클래스는 업로드된 정보들을 기록하는 레파지토리(일종의 DB 역할의 의미) 클래스이다.
            // DataEntity 클래스와 마찬가지로 샘플 구성과 이해를 돕기 위해서 작성되었다.
            var key = DataRepository.Add(entity);

            if (entity.DeletedFiles.Count > 0)
            {
                // 파일을 삭제하는 작업은 데이터베이스 트랜잭션이 끝난 후에 처리하는 것을 권장한다.
            }

            context.Response.Redirect(string.Format("view.aspx?key={0}", key));
        }
    }
}