<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge" />
<link rel="stylesheet" type="text/css" href="./common/styles/default.css" />
<title>DEXTUploadX5用Spring例(DEXTUploadNJ付き)</title>
</head>
<body>
	<header>
		<h1>DEXTUploadX5用Spring例</h1>
	</header>
	<div class="main">
		<section>
			<p>TサンプルプロジェクトはDEXTUploadX5でアップロードされたファイルをサーバー側で処理するためにDEXTUploadNJを使用し、JDK 1.8、Spring Framework 3.0.5環境に基づいています。</p>
			<p class="notice">サンプルはUTF-8環境に基づいています。</p>			 
			<p>
				DEXTUploadNJ製品はトライアルとして設定されているので別途に設定する必要がなく、30日間使用することができます。WEB-INF/dextuploadnj.config」ファイルはDEXTUploadNJ製品のライセンス（試用）ファイルです。詳細はDEXTUploadNJ製品マニュアルを参照してください。
			</p>
		</section>		
		<section>
			<h3>基本的な例</h3>
			<ul class="sample-list list-sub-2" id="tlb-basic">
				<li><p><span><a href="./multi/ex001.html">例01</a></span><span>最もシンプルな方法でファイルをアップロードする</span></p></li>
				<li><p><span><a href="./multi/ex002.html">例02</a></span><span>メタデータを扱う</span></p></li>
				<li><p><span><a href="./multi/ex003.html">例03</a></span><span>ORAF/OROFでアップロードする</span></p></li>
				<li><p><span><a href="./multi/ex004.html">例04</a></span><span>ファイルをダウンロードする</span></p></li>
				<li><p><span><a href="./multi/ex005.html">例05</a></span><span>ファイルを開く</span></p></li>
				<li><p><span><a href="./multi/ex006.html">例06</a></span><span>ファイルとフォームデータを転送する</span></p></li>
				<li><p><span><a href="./multi/ex007.html">例07</a></span><span>新規ファイルをポストに登録し、既存ファイルを削除する</span></p></li>
				<li><p><span><a href="./multi/ex008.html">例08</a></span><span>進捗ウィンドウを隠す</span></p></li>
				<li><p><span><a href="./multi/ex009.html">例09</a></span><span>進捗ウィンドウを変更する</span></p></li>
				<li><p><span><a href="./multi/ex010.html">例10</a></span><span>複数のコンポーネント</span></p></li>
				<li><p><span><a href="./multi/ex011.html">例11</a></span><span>SINGLEスタイルで複数のコンポーネントを使用する</span></p></li>
				<li><p><span><a href="./multi/ex012.html">例12</a></span><span>ファイルを圧縮してダウンロードする</span></p></li>
				<li><p><span><a href="./multi/ex013.html">例13</a></span><span>フォルダ構造でアップロードする</span></p></li>
			</ul>
		</section>
		<section>
			<h3>HDアプリケーション</h3>
			<ul class="sample-list list-sub-2" id="tlb-hd">
				<li><p><span><a href="./hd/ex001.html">例01</a></span><span>複数のファイルをダウンロードする</span></p></li>
				<li><p><span><a href="./hd/ex002.html">例02</a></span><span>イベントアドレスを呼び出す</span></p></li>
				<li><p><span><a href="./hd/ex003.html">例03</a></span><span>オプションを変更する</span></p></li>
			</ul>
		</section>
		<section>
			<h3>大容量ファイルのアップロード</h3>
			<ul class="sample-list list-sub-2" id="tlb-ext">
				<li><p><span><a href="./ext/ex001.html">例01</a></span><span>大容量ファイルのアップロード</span></p></li>
			</ul>
		</section>
		<section>
            <h3>Amazon S3</h3>
            <ul class="sample-list list-sub-2" id="tlb-awss3">
                <li><p><span><a href="./awss3/ex001.html">例01</a></span><span>Amazon S3へのファイルのアップロード</span></p></li>
                <li><p><span><a href="./awss3/ex002.html">例02</a></span><span>Amazon S3へのファイルのアップロード（保護付き）</span></p></li>
                <li><p><span><a href="./awss3/ex003.html">例03</a></span><span>Amazon S3からファイルをダウンロードする</span></p></li>
                <li><p><span><a href="./awss3/ex004.html">例04</a></span><span>Amazon S3からファイルをダウンロードする（保護付き）</span></p></li>
            </ul>
        </section>
        <section>
            <h3>NAVER CLOUD PLATFORM Object Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-ncpos">
                <li><p><span><a href="./ncpos/ex001.html">例01</a></span><span>NAVER CLOUD PLATFORM Object Storageへのファイルのアップロード</span></p></li>
                <li><p><span><a href="./ncpos/ex002.html">例02</a></span><span>NAVER CLOUD PLATFORM Object Storageへのファイルのアップロード (保護付き)</span></p></li>
                <li><p><span><a href="./ncpos/ex003.html">例03</a></span><span>NAVER CLOUD PLATFORM Object Storageからファイルをダウンロードする</span></p></li>
                <li><p><span><a href="./ncpos/ex004.html">例04</a></span><span>NAVER CLOUD PLATFORM Object Storageからファイルをダウンロードする (保護付き)</span></p></li>
            </ul>
        </section>
        <section>
            <h3>Microsoft Azure Blob Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-azrbs">
                <li><p><span><a href="./azrbs/ex001.html">例01</a></span><span>Microsoft Azure Blob Storageへのファイルのアップロード</span></p></li>
                <li><p><span><a href="./azrbs/ex002.html">例02</a></span><span>Microsoft Azure Blob Storageからファイルをダウンロードする</span></p></li>
            </ul>
        </section>
	</div>
	<footer>
		<div>Copyright ⓒ DEXTSolution Inc. All rights reserved.</div>
	</footer>
</body>
</html>