package sample_x5_nj_spring_ja;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataRepository {

	private static int incrementableKey = 0;
	private static final Map<String, DataEntity> repository = new HashMap<String, DataEntity>();
	
	public static synchronized String addDataEntity(DataEntity entity) {		
		String key = String.format("D%1$05d", ++incrementableKey);
		entity.setKey(key);
		repository.put(key, entity);		
		return key;
	}
	
	public static DataEntity getDataEntity(String key) {		
		if (repository.containsKey(key))
			return repository.get(key);
		else
			return null;
	}
	
	public static List<DataEntity> getDataEntities() {
		
		List<DataEntity> list = new ArrayList<DataEntity>();
		Set<String> keys = repository.keySet();
		Iterator<String> iterator = keys.iterator();
		while (iterator.hasNext()) {
			list.add(repository.get(iterator.next()));
		}
		return list;		
	}
	
	public static synchronized void clear() {		
		repository.clear();
		incrementableKey = 0;		
	}
}
