<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge" />
<link rel="stylesheet" type="text/css" href="./common/styles/default.css" />
<title>DEXTUploadX5 Spring Samples (with DEXTUploadNJ)</title>
</head>
<body>
	<header>
		<h1>Spring Examples</h1>
		<h3>for DEXTUploadX5</h3>
	</header>
	<div class="main">
		<section>
			<p>샘플 프로젝트는 DEXTUploadX5가 업로드한 파일을 서버 측에서 처리하기 위해서 DEXTUploadNJ 제품이 사용되며, JDK 1.8, Spring Framework 3.0.5 환경을 기반으로 제작되었다.</p>
			<p class="notice">샘플은 UTF-8 환경을 기준으로 하며, ANSI인 경우 한글 주석이 모두 깨져 보일 수 있다.</p>
			<p>
				DEXTUploadNJ 제품은 평가판 라이선스로 설정되어있으므로 별도로 설정하실 필요가 없으며, 30일간 사용할 수 있다.
				'WEB-INF/dextuploadnj.config' 파일은 DEXTUploadNJ 제품의 평가판 라이선스 파일이며, 보다 자세한 내용은 DEXTUploadNJ 제품의 매뉴얼을 참고한다.
			</p>
		</section>
		<section>
			<h3>기본 예제</h3>
			<ul class="sample-list list-sub-2" id="tlb-basic">
				<li><p><span><a href="./multi/ex001.html">예제 01</a></span><span>파일을 업로드하는 가장 간단한 예제</span></p></li>
				<li><p><span><a href="./multi/ex002.html">예제 02</a></span><span>메타데이터를 다루는 예제</span></p></li>
				<li><p><span><a href="./multi/ex003.html">예제 03</a></span><span>ORAF/OROF 파일 업로드</span></p></li>
				<li><p><span><a href="./multi/ex004.html">예제 04</a></span><span>파일 다운로드</span></p></li>
				<li><p><span><a href="./multi/ex005.html">예제 05</a></span><span>파일 열기</span></p></li>
				<li><p><span><a href="./multi/ex006.html">예제 06</a></span><span>파일과 폼 데이터를 전송</span></p></li>
				<li><p><span><a href="./multi/ex007.html">예제 07</a></span><span>게시물 수정처럼 신규 파일을 등록하고, 기존 파일을 삭제</span></p></li>
				<li><p><span><a href="./multi/ex008.html">예제 08</a></span><span>진행창 숨기기</span></p></li>
				<li><p><span><a href="./multi/ex009.html">예제 09</a></span><span>진행창 변경</span></p></li>
				<li><p><span><a href="./multi/ex010.html">예제 10</a></span><span>다중 컴포넌트 사용</span></p></li>
				<li><p><span><a href="./multi/ex011.html">예제 11</a></span><span>SINGLE스타일로 다중 컴포넌트 사용</span></p></li>
				<li><p><span><a href="./multi/ex012.html">예제 12</a></span><span>파일 압축 다운로드</span></p></li>
				<li><p><span><a href="./multi/ex013.html">예제 13</a></span><span>폴더 구조 업로드</span></p></li>
			</ul>
		</section>
		<section>
			<h3>HD 응용프로그램</h3>
			<ul class="sample-list list-sub-2" id="tlb-hd">
				<li><p><span><a href="./hd/ex001.html">예제 01</a></span><span>다중 파일 다운로드</span></p></li>
				<li><p><span><a href="./hd/ex002.html">예제 02</a></span><span>다운로드 이벤트 주소 호출</span></p></li>
				<li><p><span><a href="./hd/ex003.html">예제 03</a></span><span>옵션 변경</span></p></li>
			</ul>
		</section>
		<section>
			<h3>대용량 업로드</h3>
			<ul class="sample-list list-sub-2" id="tlb-ext">
				<li><p><span><a href="./ext/ex001.html">예제 01</a></span><span>대용량 파일 업로드</span></p></li>
			</ul>
		</section>
		<section>
            <h3>Amazon S3</h3>
            <ul class="sample-list list-sub-2" id="tlb-awss3">
                <li><p><span><a href="./awss3/ex001.html">예제 01</a></span><span>Amazon S3 파일 업로드</span></p></li>
                <li><p><span><a href="./awss3/ex002.html">예제 02</a></span><span>Amazon S3 파일 업로드 (보안)</span></p></li>
                <li><p><span><a href="./awss3/ex003.html">예제 03</a></span><span>Amazon S3 파일 다운로드</span></p></li>
                <li><p><span><a href="./awss3/ex004.html">예제 04</a></span><span>Amazon S3 파일 다운로드 (보안)</span></p></li>
            </ul>
        </section>
        <section>
            <h3>NAVER CLOUD PLATFORM Object Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-ncpos">
                <li><p><span><a href="./ncpos/ex001.html">예제 01</a></span><span>NAVER CLOUD PLATFORM Object Storage 파일 업로드</span></p></li>
                <li><p><span><a href="./ncpos/ex002.html">예제 02</a></span><span>NAVER CLOUD PLATFORM Object Storage 파일 업로드 (보안)</span></p></li>
                <li><p><span><a href="./ncpos/ex003.html">예제 03</a></span><span>NAVER CLOUD PLATFORM Object Storage 파일 다운로드</span></p></li>
                <li><p><span><a href="./ncpos/ex004.html">예제 04</a></span><span>NAVER CLOUD PLATFORM Object Storage 파일 다운로드 (보안)</span></p></li>
            </ul>
        </section>
        <section>
            <h3>Microsoft Azure Blob Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-azrbs">
                <li><p><span><a href="./azrbs/ex001.html">예제 01</a></span><span>Microsoft Azure Blob Storage 파일 업로드</span></p></li>
                <li><p><span><a href="./azrbs/ex002.html">예제 02</a></span><span>Microsoft Azure Blob Storage 파일 다운로드</span></p></li>
            </ul>
        </section>
	</div>
	<footer>
		<div>Copyright ⓒ DEXTSolution Inc. All rights reserved.</div>
	</footer>
</body>
</html>