package sample_x5_nj_spring_ko;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import software.amazon.awssdk.services.s3.model.CompletedPart;

@Controller
public class NCPOSController {
	
	private <A, B, C> Stream<C> zip(Stream<A> s1, Stream<B> s2, BiFunction<A, B, C> combiner) {
		Iterator<A> i1 = s1.iterator();
		Iterator<B> i2 = s2.iterator();
		Iterator<C> zippedIterator = new Iterator<C>() {
			@Override
			public boolean hasNext() {
				return i1.hasNext() && i2.hasNext();
			}
			@Override
			public C next() {
				return combiner.apply(i1.next(), i2.next());
			}
		};
		Spliterator<C> spliterator = Spliterators.spliteratorUnknownSize(zippedIterator, Spliterator.ORDERED);
		return StreamSupport.stream(spliterator, false);
	}
	
	@RequestMapping(value = "/service/ncpos-upload-init.do", method = RequestMethod.POST)
	public void initUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "type", required = false, defaultValue = "application/octet-stream") String type,
			@RequestParam(value = "acl", required = false, defaultValue = "private") String acl,
			@RequestParam(value = "sclass", required = false, defaultValue = "STANDARD") String sclass,
			@RequestParam(value = "metadata", required = false, defaultValue = "") String metadata,
			HttpServletResponse response) throws JsonMappingException, JsonProcessingException, IOException, URISyntaxException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		if (!key.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			response.getWriter().write(helper.initializeUpload(key, sclass, acl, type, metadata));
		} else {		
			response.setStatus(400);
			response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	@RequestMapping(value = "/service/ncpos-upload-geturl.do", method = RequestMethod.POST)
	public void getPresignedUploadURL(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			@RequestParam(value = "pnum", required = false, defaultValue = "") String pnum,
			HttpServletResponse response) throws IOException, URISyntaxException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		if (!key.isEmpty() && !uid.isEmpty() && !pnum.isEmpty()) {
			int pi = Integer.parseInt(pnum);
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			response.getWriter().write(helper.getPresignedURL(key, uid, pi));
		} else {		
			response.setStatus(400);
			response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}	
	
	@RequestMapping(value = "/service/ncpos-upload-complete.do", method = RequestMethod.POST)
	public void completeUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			@RequestParam(value = "pnum", required = false, defaultValue = "") List<String> pnums,
			@RequestParam(value = "etag", required = false, defaultValue = "") List<String> etags,
			HttpServletResponse response) throws IOException, URISyntaxException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		Stream<CompletedPart> zipped = zip(
				pnums.stream().map(v -> Integer.parseInt(v)),
				etags.stream(),
				(v1, v2) -> CompletedPart.builder().partNumber(v1).eTag(v2).build());
		
		List<CompletedPart> parts = zipped.collect(Collectors.toList());
		
		if (!key.isEmpty() && !uid.isEmpty() && parts.size() > 0) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			response.getWriter().write(helper.completeUpload(key, uid, parts));
		} else {		
			response.setStatus(400);
			response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	@RequestMapping(value = "/service/ncpos-upload-abort.do", method = RequestMethod.POST)
	public void abortUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			HttpServletResponse response) throws IOException, URISyntaxException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		if (!key.isEmpty() && !uid.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			helper.abortUpload(key, uid);
		} else {		
			response.setStatus(400);
			response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	@RequestMapping(value = "/service/ncpos-download-geturl.do", method = RequestMethod.POST)
	public void getPresignedDownloadURL(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			HttpServletResponse response) throws IOException, URISyntaxException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		if (!key.isEmpty()) {
			NCPOSDownloadHelper helper = new NCPOSDownloadHelper();
			response.getWriter().write(helper.getPresignedURL(key));
		} else {		
			response.setStatus(400);
			response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
}
