package sample_x5_nj_boot_gradle_jar_ko;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SampleController {
	
	@GetMapping("/")
	public String home() {
		return "index";
	}
	
	@GetMapping("/doc-{classifier}")
	public String document(@PathVariable String classifier) {
		return String.format("doc-%s", classifier);
	}
	
	@GetMapping("/ex-{classifier1}-{classifier2}")
	public String example(@PathVariable String classifier1, @PathVariable String classifier2) {
		return String.format("ex-%s-%s", classifier1, classifier2);
	}
	
	@PostMapping("/process-form")
	public String processForm(
			/* FakeData는 폼에서 전달되는 값을 가지고 있는 VO 클래스로써 일종의 예시입니다. */
			FakeData form,
			@RequestParam(value = "newFileKeys", required = false) String newFileKeys,
			@RequestParam(value = "deleteFileKeys", required = false) String deleteFileKeys) {
		
		List<FakeFile> files = form.getFiles();
		
		// DB에 저장된 파일 정보를 FakeData 인스턴스에 연결하는 일종의 작업으로 이해하면 된다.
		String[] tokens = newFileKeys.split(";");
		FakeFile file = null;
		for (String key : tokens) {
			if (key.isEmpty()) continue;
			file = FakeFileService.get(key);
			if (file != null) files.add(file);
		}
		
		if (deleteFileKeys != null && deleteFileKeys.length() > 0) {
			form.setDeleteDescription(deleteFileKeys + " 파일이 삭제되었습니다.");
		} else {
			form.setDeleteDescription("삭제된 파일이 없습니다.");
		}
		
		// DB에 새로운 폼 데이터를 등록하며, 이때, 데이터와 파일은 관계를 갖도록 연결할 수 있다.
		String key = FakeDataService.add(form);
		
		if (deleteFileKeys != null) {
			// 만일 삭제된 파일 정보가 있다면, 물리적 파일을 이 시점에 삭제해야 한다.
		}
		
		return "redirect:/ex-result-form?key=".concat(key);
	}
	
	@GetMapping("/ex-result-{classifier}")
	public ModelAndView result(HttpServletRequest request, @PathVariable String classifier) {
		if (classifier.equals("form")) {
			
			FakeData data = FakeDataService.get(request.getParameter("key"));
			return new ModelAndView(String.format("ex-result-%s", classifier), "data", data);
			
		} else throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
	}
	
	@GetMapping(value = "/hd-event", produces = "text/plain;charset=UTF-8")
	@ResponseBody
	public String hdevent(@RequestParam(value = "action") String action, @RequestParam(value = "key") String key) {		
		// 테스트를 위해 표준 출력으로 요청 내역을 출력한다.
		System.out.println(String.format("Action: %s, Key: %s", action, key));
		return "OK";
	}
	
}
