package sample_x5_nj_boot_gradle_jar_ko;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.servlet.http.HttpServletResponse;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import software.amazon.awssdk.services.s3.model.CompletedPart;

@Controller
public class NCPOSController {
	
	private <A, B, C> Stream<C> zip(Stream<A> s1, Stream<B> s2, BiFunction<A, B, C> combiner) {
		Iterator<A> i1 = s1.iterator();
		Iterator<B> i2 = s2.iterator();
		Iterator<C> zippedIterator = new Iterator<C>() {
			@Override
			public boolean hasNext() {
				return i1.hasNext() && i2.hasNext();
			}
			@Override
			public C next() {
				return combiner.apply(i1.next(), i2.next());
			}
		};
		Spliterator<C> spliterator = Spliterators.spliteratorUnknownSize(zippedIterator, Spliterator.ORDERED);
		return StreamSupport.stream(spliterator, false);
	}
	
	@PostMapping(value = "/ncpos-upload-init", produces = "application/json;charset=UTF-8")
	public ResponseEntity<Object> initUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "type", required = false, defaultValue = "application/octet-stream") String type,
			@RequestParam(value = "acl", required = false, defaultValue = "private") String acl,
			@RequestParam(value = "sclass", required = false, defaultValue = "STANDARD") String sclass,
			@RequestParam(value = "metadata", required = false, defaultValue = "") String metadata,
			HttpServletResponse response) throws JsonMappingException, JsonProcessingException, URISyntaxException {
		
		if (!key.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			return new ResponseEntity<>(helper.initializeUpload(key, sclass, acl, type, metadata), HttpStatus.OK);
		} else {
			Map<String, Object> map = new HashMap<>();
			map.put("error", "Invalid parameters.");
			return new ResponseEntity<>(map, HttpStatus.BAD_REQUEST);
		}
	}
	
	@PostMapping(value = "/ncpos-upload-geturl", produces = "application/json;charset=UTF-8")
	public ResponseEntity<Object> getPresignedUploadURL(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			@RequestParam(value = "pnum", required = false, defaultValue = "") String pnum,
			HttpServletResponse response) throws URISyntaxException {
		
		if (!key.isEmpty() && !uid.isEmpty() && !pnum.isEmpty()) {
			int pi = Integer.parseInt(pnum);
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			return new ResponseEntity<>(helper.getPresignedURL(key, uid, pi), HttpStatus.OK);
		} else {		
			Map<String, Object> map = new HashMap<>();
			map.put("error", "Invalid parameters.");
			return new ResponseEntity<>(map, HttpStatus.BAD_REQUEST);
		}
	}
	
	@PostMapping(value = "/ncpos-upload-complete", produces = "application/json;charset=UTF-8")
	public ResponseEntity<Object> completeUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			@RequestParam(value = "pnum", required = false, defaultValue = "") List<String> pnums,
			@RequestParam(value = "etag", required = false, defaultValue = "") List<String> etags,
			HttpServletResponse response) throws URISyntaxException {
		
		Stream<CompletedPart> zipped = zip(
				pnums.stream().map(v -> Integer.parseInt(v)),
				etags.stream(),
				(v1, v2) -> CompletedPart.builder().partNumber(v1).eTag(v2).build());
		
		List<CompletedPart> parts = zipped.collect(Collectors.toList());
		
		if (!key.isEmpty() && !uid.isEmpty() && parts.size() > 0) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			return new ResponseEntity<>(helper.completeUpload(key, uid, parts), HttpStatus.OK);
		} else {		
			Map<String, Object> map = new HashMap<>();
			map.put("error", "Invalid parameters.");
			return new ResponseEntity<>(map, HttpStatus.BAD_REQUEST);
		}
	}
	
	@PostMapping(value = "/ncpos-upload-abort", produces = "application/json;charset=UTF-8")
	public ResponseEntity<Object> abortUpload(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			@RequestParam(value = "uid", required = false, defaultValue = "") String uid,
			HttpServletResponse response) throws URISyntaxException {
		
		if (!key.isEmpty() && !uid.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			helper.abortUpload(key, uid);
			return new ResponseEntity<>(null, HttpStatus.OK);
		} else {		
			Map<String, Object> map = new HashMap<>();
			map.put("error", "Invalid parameters.");
			return new ResponseEntity<>(map, HttpStatus.BAD_REQUEST);
		}
	}
	
	@PostMapping(value = "/ncpos-download-geturl", produces = "application/json;charset=UTF-8")
	public ResponseEntity<Object> getPresignedDownloadURL(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			HttpServletResponse response) throws IOException, URISyntaxException {
		
		if (!key.isEmpty()) {
			NCPOSDownloadHelper helper = new NCPOSDownloadHelper();
			return new ResponseEntity<>(helper.getPresignedURL(key), HttpStatus.OK);
		} else {		
			Map<String, Object> map = new HashMap<>();
			map.put("error", "Invalid parameters.");
			return new ResponseEntity<>(map, HttpStatus.BAD_REQUEST);
		}
	}
}
