package sample_x5_nj_boot_gradle_jar_ko;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.sas.SasProtocol;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AzureSasTokenGenerator {
	
	private final static String ACCOUNT_NAME = "";
	private final static String CONTAINER_NAME = "";
	private final static String ACCESSKEY = "";
	
	public String generateBlobListSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
        // SAS 유효기간 (서버 시간차 보정: 5분 일찍 시작, 1시간 유효)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 권한: Read + List (커밋되지 않은 블록 목록을 읽기 위해 필요)
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true)
                .setListPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Blob 기준으로 SAS 토큰 생성
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}
	
	public String generateContainerSasToken() {
        	
    	StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
    	
    	// SAS 유효기간 (서버 시간차 보정: 5분 일찍 시작, 1시간 유효)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 권한: Create + Write (새로운 Blob 생성)
        BlobSasPermission permissions = new BlobSasPermission()
        		.setCreatePermission(true)
        		.setWritePermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);	        
        
        // 컨테이너 기준으로 SAS 토큰 생성
        String sasToken = containerClient.generateSas(sasValues);
        
        return sasToken;
        
	}
	
	public String generateBlobSasToken(String blobName) {
        
		StorageSharedKeyCredential credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCESSKEY);       
    	BlobServiceClient serviceClient = new BlobServiceClientBuilder()
        		.endpoint(String.format("https://%s.blob.core.windows.net", ACCOUNT_NAME))
        		.credential(credential)
        		.buildClient();        
        BlobContainerClient containerClient = serviceClient.getBlobContainerClient(CONTAINER_NAME);
        BlobClient blobClient = containerClient.getBlobClient(blobName);
        
		// SAS 유효기간 (서버 시간차 보정: 5분 일찍 시작, 1시간 유효)
        OffsetDateTime startTime = OffsetDateTime.now(ZoneOffset.UTC).minusMinutes(5);
        OffsetDateTime expiryTime = OffsetDateTime.now(ZoneOffset.UTC).plusMinutes(60);

        // 권한: Read (Blob 내용을 읽기 위해 필요)
        BlobSasPermission permissions = new BlobSasPermission()
                .setReadPermission(true);        
        BlobServiceSasSignatureValues sasValues = new BlobServiceSasSignatureValues(expiryTime, permissions)
        		.setStartTime(startTime)
        		.setProtocol(SasProtocol.HTTPS_ONLY);
        
        // Blob 기준으로 SAS 토큰 생성
        String sasToken = blobClient.generateSas(sasValues);
        
        return sasToken;
	}

}
